/*
 * Decompiled with CFR 0.152.
 */
package digital.ivan.lightchain.core.chain.impl;

import digital.ivan.lightchain.core.chain.ISyncChain;
import digital.ivan.lightchain.core.chain.prompt.SystemMessagePropmtTemplate;
import digital.ivan.lightchain.core.context.model.Message;
import digital.ivan.lightchain.core.exception.OutputProcessingException;
import digital.ivan.lightchain.core.model.ILLModel;
import digital.ivan.lightchain.core.model.LLMInput;
import digital.ivan.lightchain.core.model.LLMOutput;
import digital.ivan.lightchain.core.model.func.LLMInputFunc;
import digital.ivan.lightchain.core.prompt.IPromptTemplateProvider;
import digital.ivan.lightchain.core.router.ToolCall;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AgentRoutedFuncChain
implements ISyncChain<ToolCall, LLMInputFunc> {
    private static final String SYSTEM_ROLE = "system";
    private final ILLModel<ToolCall, LLMInputFunc> model;
    private final IPromptTemplateProvider promptTemplateProvider = new SystemMessagePropmtTemplate();

    public AgentRoutedFuncChain(ILLModel<ToolCall, LLMInputFunc> model) {
        this.model = model;
    }

    @Override
    public LLMOutput<ToolCall> run(LLMInputFunc input, Logger logger) {
        input.getContext().add(new Message(SYSTEM_ROLE, this.promptTemplateProvider.getPrompt(), System.currentTimeMillis()));
        LLMOutput output = this.model.generate(new LLMInput<LLMInputFunc>(input)).stream().max(Comparator.comparingDouble(LLMOutput::getProbability)).orElseThrow(() -> new OutputProcessingException("No result output of LLM"));
        if (logger != null) {
            logger.log(Level.INFO, "For input: " + input.toString() + ", Output: " + output.getValue());
        }
        return output;
    }
}

