/*
 * Decompiled with CFR 0.152.
 */
package digital.ivan.lightchain.core.chain.impl;

import digital.ivan.lightchain.core.chain.ISyncChain;
import digital.ivan.lightchain.core.chain.prompt.AgentRoutedPromptTemplateProvider;
import digital.ivan.lightchain.core.exception.OutputProcessingException;
import digital.ivan.lightchain.core.model.ILLModel;
import digital.ivan.lightchain.core.model.LLMInput;
import digital.ivan.lightchain.core.model.LLMOutput;
import digital.ivan.lightchain.core.parser.IOutputParser;
import digital.ivan.lightchain.core.prompt.IPromptTemplateProvider;
import digital.ivan.lightchain.core.prompt.KeyConsts;
import digital.ivan.lightchain.core.prompt.SimplePromptBuilder;
import digital.ivan.lightchain.core.router.IRouterConfig;
import digital.ivan.lightchain.core.router.ToolCall;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AgentRoutedChain
implements ISyncChain<ToolCall, Map<String, String>> {
    private final ILLModel<String, String> model;
    private final SimplePromptBuilder promptBuilder;
    private final String toolsDescription;
    private final String toolsList;
    private final IOutputParser parser;

    public AgentRoutedChain(ILLModel<String, String> model, IOutputParser parser, IRouterConfig properties, IPromptTemplateProvider templateProvider) {
        this.model = model;
        this.parser = parser;
        this.promptBuilder = new SimplePromptBuilder(templateProvider);
        this.toolsDescription = properties.getDescription();
        this.toolsList = properties.getStringToolsList();
    }

    public AgentRoutedChain(ILLModel<String, String> model, IOutputParser parser, IRouterConfig properties) {
        this.model = model;
        this.parser = parser;
        this.promptBuilder = new SimplePromptBuilder(new AgentRoutedPromptTemplateProvider());
        this.toolsDescription = properties.getDescription();
        this.toolsList = properties.getStringToolsList();
    }

    @Override
    public LLMOutput<ToolCall> run(Map<String, String> params, Logger logger) throws OutputProcessingException {
        params.put(KeyConsts.TOOLS_DESCRIPTION.name(), this.toolsDescription);
        params.put(KeyConsts.TOOLS_LIST.name(), this.toolsList);
        return new LLMOutput<ToolCall>(this.parser.parse(this.callModel(params, logger)));
    }

    private String callModel(Map<String, String> params, Logger logger) {
        HashMap<String, String> localParams = new HashMap<String, String>(params);
        LLMInput<String> input = new LLMInput<String>(this.promptBuilder.build(localParams));
        Optional<LLMOutput> optional = this.model.generate(input).stream().max(Comparator.comparingDouble(LLMOutput::getProbability));
        LLMOutput output = optional.orElseThrow(() -> new OutputProcessingException("No result output of LLM"));
        if (logger != null) {
            logger.log(Level.INFO, "For input: " + input.getValue() + ", Output: " + (String)output.getValue());
        }
        return (String)output.getValue();
    }
}

