/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.build.publish.util;

import java.util.Set;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.artifacts.repositories.PasswordCredentials;
import org.hibernate.build.publish.auth.Credentials;
import org.hibernate.build.publish.auth.CredentialsProvider;
import org.hibernate.build.publish.auth.CredentialsProviderRegistry;

public class Helper {
    private static final Set<String> AUTHENTICATABLE_PROTOCOLS = Set.of("http", "https", "sftp");

    public static void applyCredentials(MavenArtifactRepository repo, CredentialsProviderRegistry credentialsProviderRegistry) {
        if (!AUTHENTICATABLE_PROTOCOLS.contains(repo.getUrl().getScheme().toLowerCase())) {
            return;
        }
        Credentials credentials = Helper.locateAuthenticationCredentials(repo.getName(), credentialsProviderRegistry);
        if (credentials == null) {
            return;
        }
        PasswordCredentials repoCredentials = repo.getCredentials();
        repoCredentials.setUsername(credentials.getUserName());
        repoCredentials.setPassword(credentials.getPassword());
    }

    public static Credentials locateAuthenticationCredentials(String repositoryId, CredentialsProviderRegistry credentialsProviderRegistry) {
        for (CredentialsProvider provider : credentialsProviderRegistry.providers()) {
            Credentials authentication = provider.determineAuthentication(repositoryId);
            if (authentication == null || authentication.getPassword() == null) continue;
            return authentication;
        }
        return null;
    }
}

