/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.build.publish.auth.maven.pwd;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.build.publish.auth.maven.pwd.PropertyMap;
import org.hibernate.build.publish.auth.maven.pwd.SimplePropertyMap;
import org.hibernate.build.publish.auth.maven.pwd.ValueProcessor;

public final class ValueProcessorRegex
implements ValueProcessor {
    public static final ValueProcessorRegex INSTANCE = new ValueProcessorRegex();
    private static final Pattern PATTERN = Pattern.compile("\\$\\{([a-zA-Z0-9-._]+)}");
    private final PropertyMap systemPropertiesAndEnv = SimplePropertyMap.INSTANCE;

    private ValueProcessorRegex() {
    }

    @Override
    public String processValue(String value) {
        if (value == null) {
            return null;
        }
        Matcher matcher = PATTERN.matcher(value);
        StringBuilder s = new StringBuilder();
        while (matcher.find()) {
            String group = matcher.group(1);
            matcher.appendReplacement(s, this.systemPropertiesAndEnv.get(group).map(Matcher::quoteReplacement).orElse(Matcher.quoteReplacement(matcher.group())));
        }
        if (s.length() == 0) {
            return value;
        }
        return s.toString();
    }
}

