/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.build.publish.auth.maven.pwd;

import org.hibernate.build.publish.auth.maven.pwd.PasswordProcessor;
import org.hibernate.build.publish.auth.maven.pwd.PasswordStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.components.cipher.PlexusCipher;
import org.sonatype.plexus.components.cipher.PlexusCipherException;

public class DecryptionPasswordStrategy
implements PasswordStrategy {
    private static final Logger log = LoggerFactory.getLogger(PasswordProcessor.class);
    private final PlexusCipher cipher;
    private final String masterPassword;

    public DecryptionPasswordStrategy(PlexusCipher cipher, String masterPassword) {
        this.cipher = cipher;
        this.masterPassword = masterPassword;
    }

    @Override
    public String interpretPassword(String password) {
        return DecryptionPasswordStrategy.decrypt(this.cipher, password, this.masterPassword);
    }

    public static String decrypt(PlexusCipher cipher, String encryptedPassword, String passPhrase) {
        try {
            return cipher.decryptDecorated(encryptedPassword, passPhrase);
        }
        catch (PlexusCipherException e) {
            log.warn("Unable to decrypt Maven password using PlexusCipher", (Throwable)e);
            return encryptedPassword;
        }
    }
}

