/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.build.publish.auth.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.hibernate.build.publish.auth.Credentials;
import org.hibernate.build.publish.auth.CredentialsProvider;
import org.hibernate.build.publish.auth.maven.pwd.PasswordProcessor;
import org.hibernate.build.publish.auth.maven.pwd.ValueProcessor;
import org.hibernate.build.publish.auth.maven.pwd.ValueProcessorRegex;
import org.hibernate.build.publish.util.DomHelper;
import org.hibernate.build.publish.util.PathHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class SettingsXmlCredentialsProvider
implements CredentialsProvider {
    private static final Logger log = LoggerFactory.getLogger(SettingsXmlCredentialsProvider.class);
    public static final String SETTINGS_LOCATION_OVERRIDE = "maven.settings";
    private static final String SETTINGS_DEFAULT_LOCATION = "~/.m2/settings.xml";
    private final Map<String, Credentials> credentialsByRepoIdMap;
    public final ValueProcessor valueProcessor = ValueProcessorRegex.INSTANCE;

    public SettingsXmlCredentialsProvider() {
        File settingsFile = this.determineSettingsFileLocation();
        this.credentialsByRepoIdMap = this.extractCredentialsFromSettings(settingsFile);
    }

    private File determineSettingsFileLocation() {
        String location = System.getProperty(SETTINGS_LOCATION_OVERRIDE, SETTINGS_DEFAULT_LOCATION);
        return new File(PathHelper.normalizePath(location));
    }

    private Map<String, Credentials> extractCredentialsFromSettings(File settingsFile) {
        if (!settingsFile.exists()) {
            log.warn("Maven settings.xml file did not exist : " + settingsFile.getAbsolutePath());
            return Collections.emptyMap();
        }
        try {
            SAXReader saxReader = this.buildSAXReader();
            InputSource inputSource = new InputSource(new FileInputStream(settingsFile));
            try {
                List<Element> serverElements = this.seekServerElements(saxReader.read(inputSource));
                if (serverElements.isEmpty()) {
                    log.warn("Maven settings.xml file did not contain <sever/> elements : " + settingsFile.getAbsolutePath());
                    return Collections.emptyMap();
                }
                HashMap<String, Credentials> result = new HashMap<String, Credentials>();
                for (Element serverElement : serverElements) {
                    String id = DomHelper.extractValue(serverElement.element("id"));
                    if (id == null) continue;
                    log.debug("Adding credentials for server : " + id);
                    Credentials authentication = this.extractCredentials(serverElement);
                    if (authentication == null) continue;
                    result.put(id, authentication);
                }
                return Collections.unmodifiableMap(result);
            }
            catch (DocumentException e) {
                log.error("Error reading Maven settings.xml", (Throwable)e);
            }
        }
        catch (FileNotFoundException e) {
            log.info("Unable to locate Maven settings.xml");
        }
        return Collections.emptyMap();
    }

    private SAXReader buildSAXReader() {
        SAXReader saxReader = new SAXReader(new DocumentFactory());
        saxReader.setMergeAdjacentText(true);
        return saxReader;
    }

    private Credentials extractCredentials(Element serverElement) {
        String passwordValue = this.extractValue(serverElement.element("password"));
        if (passwordValue == null) {
            return null;
        }
        String password = PasswordProcessor.INSTANCE.resolvePasswordStrategy(passwordValue).interpretPassword(passwordValue);
        Credentials authentication = new Credentials();
        authentication.setUserName(this.extractValue(serverElement.element("username")));
        authentication.setPassword(password);
        authentication.setPrivateKey(this.extractValue(serverElement.element("privateKey")));
        authentication.setPassphrase(this.extractValue(serverElement.element("passphrase")));
        return authentication;
    }

    private String extractValue(Element element) {
        return this.valueProcessor.processValue(DomHelper.extractValue(element));
    }

    private List<Element> seekServerElements(Document document) {
        Element serversElement;
        Element settingsElement = document.getRootElement();
        if (settingsElement != null && (serversElement = settingsElement.element("servers")) != null) {
            return serversElement.elements("server");
        }
        return Collections.emptyList();
    }

    @Override
    public Credentials determineAuthentication(String repoId) {
        return this.credentialsByRepoIdMap.get(repoId);
    }
}

