/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.build.publish.auth.maven.pwd;

import java.io.File;
import org.hibernate.build.publish.auth.maven.pwd.DecryptionPasswordStrategy;
import org.hibernate.build.publish.auth.maven.pwd.DefaultPasswordStrategy;
import org.hibernate.build.publish.auth.maven.pwd.PasswordStrategy;
import org.hibernate.build.publish.util.PathHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.components.cipher.DefaultPlexusCipher;
import org.sonatype.plexus.components.cipher.PlexusCipher;
import org.sonatype.plexus.components.cipher.PlexusCipherException;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;
import org.sonatype.plexus.components.sec.dispatcher.SecUtil;
import org.sonatype.plexus.components.sec.dispatcher.model.SettingsSecurity;

public class PasswordProcessor {
    private static final String DEFAULT_SECURITY_SETTINGS_LOCATION = "~/.m2/settings-security.xml";
    private static final Logger log = LoggerFactory.getLogger(PasswordProcessor.class);
    public static final PasswordProcessor INSTANCE = new PasswordProcessor();
    private final PlexusCipher cipher = PasswordProcessor.buildCipher();
    private DecryptionPasswordStrategy decryptionStrategy;

    public PasswordStrategy resolvePasswordStrategy(String password) {
        if (this.cipher != null && this.cipher.isEncryptedString(password)) {
            if (this.decryptionStrategy == null) {
                String encryptedMasterPassword;
                File securitySettingsFile = this.determineSecuritySettingsFileLocation();
                String string = encryptedMasterPassword = securitySettingsFile.exists() ? this.extractMasterPassword(securitySettingsFile) : null;
                if (encryptedMasterPassword != null) {
                    log.debug("Encrypted master password: " + encryptedMasterPassword);
                    String passPhrase = DecryptionPasswordStrategy.decrypt(this.cipher, encryptedMasterPassword, "settings.security");
                    if (passPhrase != null) {
                        this.decryptionStrategy = new DecryptionPasswordStrategy(this.cipher, passPhrase);
                    }
                }
            }
            return this.decryptionStrategy;
        }
        return DefaultPasswordStrategy.INSTANCE;
    }

    private String extractMasterPassword(File securitySettingsFile) {
        try {
            SettingsSecurity settingsSecurity = SecUtil.read((String)securitySettingsFile.getAbsolutePath(), (boolean)true);
            return settingsSecurity == null ? null : settingsSecurity.getMaster();
        }
        catch (SecDispatcherException e) {
            log.warn("Unable to read Maven security settings file", (Throwable)e);
            return null;
        }
    }

    private File determineSecuritySettingsFileLocation() {
        String location = System.getProperty("settings.security", DEFAULT_SECURITY_SETTINGS_LOCATION);
        return new File(PathHelper.normalizePath(location));
    }

    private static PlexusCipher buildCipher() {
        try {
            return new DefaultPlexusCipher();
        }
        catch (PlexusCipherException e) {
            log.error("Unable to create PlexusCipher in order to decrypt Maven passwords");
            return null;
        }
    }
}

