/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.build.publish.auth.maven;

import java.lang.reflect.InvocationTargetException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.hibernate.build.publish.auth.CredentialsProviderRegistry;
import org.hibernate.build.publish.util.Helper;

public class PublishingRepoHandler {
    public static void apply(Project project, CredentialsProviderRegistry credentialsProviderRegistry) {
        if (project.getExtensions().findByName("publishing") == null) {
            return;
        }
        project.afterEvaluate(p -> {
            RepositoryHandler repos;
            try {
                Class<?> clazz = project.getClass().getClassLoader().loadClass("org.gradle.api.publish.PublishingExtension");
                Object publishingExtension = p.getExtensions().getByType(clazz);
                repos = (RepositoryHandler)clazz.getMethod("getRepositories", new Class[0]).invoke(publishingExtension, new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            repos.forEach(repo -> {
                if (repo instanceof MavenArtifactRepository) {
                    MavenArtifactRepository mavenRepo = (MavenArtifactRepository)repo;
                    Helper.applyCredentials(mavenRepo, credentialsProviderRegistry);
                }
            });
        });
    }
}

