/*
 * Decompiled with CFR 0.152.
 */
package digital.bakehouse.rxusecase.decorator;

import digital.bakehouse.rxusecase.Request;
import digital.bakehouse.rxusecase.Response;
import digital.bakehouse.rxusecase.decorator.UseCaseDecorator;
import io.reactivex.Observable;

public final class LogDecorator
implements UseCaseDecorator {
    private static final String DELIMITER = "~~";
    private static final LogOutput SYSTEM_OUTPUT = System.out::println;
    private LogOutput logOutput;

    private LogDecorator(LogOutput logOutput) {
        this.logOutput = logOutput;
    }

    public static LogDecorator getDefault() {
        return new LogDecorator(SYSTEM_OUTPUT);
    }

    public static LogDecorator getWithOutput(LogOutput logOutput) {
        return new LogDecorator(logOutput);
    }

    @Override
    public final <I, O> Observable<Response<O>> decorate(Observable<Response<O>> origin, Request<I> request) {
        TimeHolder timeHolder = new TimeHolder();
        return origin.doOnSubscribe(disposable -> {
            timeHolder.initialize();
            this.logAction(request, "Subscribe", new Object[0]);
        }).doOnNext(response -> {
            if (response.isSuccessful()) {
                this.logAction(request, "Success = %s", response.getData());
            } else {
                this.logAction(request, "Failure = %s", response.getFailure());
            }
        }).doOnError(throwable -> this.logAction(request, "Exception = %s", throwable)).doOnComplete(() -> this.logAction(request, "Complete", new Object[0])).doOnTerminate(() -> this.logAction(request, "Finish %s Elapsed Time: %sms", DELIMITER, timeHolder.diff()));
    }

    private void logAction(Request request, String message, Object ... arguments) {
        if (arguments != null && arguments.length > 0) {
            message = String.format(message, arguments);
        }
        String logMessage = String.format("%2$s(%3$s) %1$s %4$s", DELIMITER, request.getOrigin(), request.getInput(), message);
        this.logOutput.log(logMessage);
    }

    public static interface LogOutput {
        public void log(String var1);
    }

    private static class TimeHolder {
        private long timeMillis;

        private TimeHolder() {
        }

        private long diff() {
            return System.currentTimeMillis() - this.timeMillis;
        }

        private void initialize() {
            this.timeMillis = System.currentTimeMillis();
        }
    }
}

