/*
 * Decompiled with CFR 0.152.
 */
package digital.bakehouse.rxusecase.decorator;

import digital.bakehouse.rxusecase.Failure;
import digital.bakehouse.rxusecase.FailureException;
import digital.bakehouse.rxusecase.Request;
import digital.bakehouse.rxusecase.Response;
import digital.bakehouse.rxusecase.decorator.UseCaseDecorator;
import io.reactivex.Observable;

public final class FailureExceptionConverter
implements UseCaseDecorator {
    private Failure fallbackFailure;

    private FailureExceptionConverter() {
    }

    private FailureExceptionConverter(Failure fallbackFailure) {
        this.fallbackFailure = fallbackFailure;
    }

    public static FailureExceptionConverter getDefault() {
        return new FailureExceptionConverter();
    }

    public static FailureExceptionConverter getWithFallback(Failure fallbackFailure) {
        return new FailureExceptionConverter(fallbackFailure);
    }

    @Override
    public final <I, O> Observable<Response<O>> decorate(Observable<Response<O>> origin, Request<I> ignored) {
        return origin.onErrorResumeNext(throwable -> {
            if (throwable instanceof FailureException) {
                return FailureExceptionConverter.failureResponse(((FailureException)throwable).getFailure());
            }
            if (this.fallbackFailure != null) {
                return FailureExceptionConverter.failureResponse(this.fallbackFailure);
            }
            return Observable.error((Throwable)throwable);
        });
    }

    private static <O> Observable<Response<O>> failureResponse(Failure failure) {
        Response failureResponse = Response.fail(failure);
        return Observable.just(failureResponse);
    }
}

