/*
 * Decompiled with CFR 0.152.
 */
package digital.bakehouse.rxusecase;

import digital.bakehouse.rxusecase.Failure;
import digital.bakehouse.rxusecase.Request;
import digital.bakehouse.rxusecase.Response;
import digital.bakehouse.rxusecase.decorator.FailureExceptionConverter;
import digital.bakehouse.rxusecase.decorator.UseCaseDecorator;
import digital.bakehouse.rxusecase.operation.Asynchronous;
import digital.bakehouse.rxusecase.operation.Continuous;
import digital.bakehouse.rxusecase.operation.Synchronous;
import digital.bakehouse.rxusecase.toolbox.SafeEmitter;
import io.reactivex.Observable;
import io.reactivex.ObservableOnSubscribe;
import java.util.ArrayList;
import java.util.List;

public abstract class RxUseCase<I, O> {
    private final String ORIGIN = this.getClass().getSimpleName();
    private static final List<UseCaseDecorator> DECORATORS = new ArrayList<UseCaseDecorator>();

    public final Observable<Response<O>> create(I input) {
        return this.create(this.wrapRequest(input));
    }

    public final Observable<Response<O>> create(Request<I> request) {
        return RxUseCase.decorate(this.execute(request.getInput()), RxUseCase.withOrigin(request, this.ORIGIN));
    }

    public final Response<O> get(I input) {
        return this.get(RxUseCase.newRequest(input));
    }

    public final Response<O> get(Request<I> request) {
        return (Response)this.create(request).blockingFirst();
    }

    protected abstract Observable<Response<O>> execute(I var1);

    private Request<I> wrapRequest(I input) {
        return Request.newBuilder(input).build();
    }

    private static <I> Request<I> newRequest(I input) {
        return RxUseCase.withOrigin(Request.newBuilder(input).build(), RxUseCase.class.getSimpleName());
    }

    private static <I> Request<I> withOrigin(Request<I> request, String origin) {
        return request.origin(origin);
    }

    public static void addDecorator(UseCaseDecorator decorator) {
        DECORATORS.add(decorator);
    }

    public static void removeDecorator(UseCaseDecorator decorator) {
        DECORATORS.remove(decorator);
    }

    public static <I, O> Observable<Response<O>> toRx(Synchronous<I, O> operation, I input) {
        return Observable.fromCallable(() -> operation.act(input)).map(Response::succeed);
    }

    public static <I, O> Observable<Response<O>> wrap(Synchronous<I, O> operation, I input) {
        return RxUseCase.wrap(operation, RxUseCase.newRequest(input));
    }

    public static <I, O> Observable<Response<O>> wrap(Synchronous<I, O> operation, Request<I> request) {
        return RxUseCase.decorate(RxUseCase.toRx(operation, request.getInput()), request);
    }

    public static <I, O> Observable<Response<O>> toRx(Asynchronous<I, O> operation, I input) {
        return RxUseCase.create(emitter -> operation.act(input, new Asynchronous.Callback<O>(){

            @Override
            public void succeed(O output) {
                emitter.onNext(Response.succeed(output));
                emitter.onComplete();
            }

            @Override
            public void fail(Failure failure) {
                emitter.onNext(Response.fail(failure));
                emitter.onComplete();
            }
        }));
    }

    public static <I, O> Observable<Response<O>> wrap(Asynchronous<I, O> operation, I input) {
        return RxUseCase.wrap(operation, RxUseCase.newRequest(input));
    }

    public static <I, O> Observable<Response<O>> wrap(Asynchronous<I, O> operation, Request<I> request) {
        return RxUseCase.decorate(RxUseCase.toRx(operation, request.getInput()), request);
    }

    public static <I, O> Observable<Response<O>> toRx(Continuous<I, O> operation, I input) {
        return RxUseCase.create(emitter -> operation.act(input, new Continuous.Notifier<O>(){

            @Override
            public void notify(O output) {
                emitter.onNext(Response.succeed(output));
            }

            @Override
            public void complete() {
                emitter.onComplete();
            }

            @Override
            public void complete(Failure failure) {
                emitter.onNext(Response.fail(failure));
                emitter.onComplete();
            }
        })).doOnDispose(() -> operation.cancel(input));
    }

    public static <I, O> Observable<Response<O>> wrap(Continuous<I, O> operation, I input) {
        return RxUseCase.wrap(operation, RxUseCase.newRequest(input));
    }

    public static <I, O> Observable<Response<O>> wrap(Continuous<I, O> operation, Request<I> request) {
        return RxUseCase.decorate(RxUseCase.toRx(operation, request.getInput()), request);
    }

    public static <I, O> Observable<Response<O>> wrap(Observable<O> stream, I input) {
        return RxUseCase.wrap(stream, RxUseCase.newRequest(input));
    }

    public static <I, O> Observable<Response<O>> wrap(Observable<O> stream, Request<I> request) {
        return RxUseCase.decorate(stream.map(Response::succeed), request);
    }

    private static <I, O> Observable<Response<O>> decorate(Observable<Response<O>> stream, Request<I> request) {
        return Observable.defer(() -> {
            Observable result = stream;
            for (UseCaseDecorator decorator : DECORATORS) {
                result = decorator.decorate(result, request);
            }
            return result;
        });
    }

    private static <O> Observable<Response<O>> create(ObservableOnSubscribe<Response<O>> subscriber) {
        return Observable.create(emitter -> subscriber.subscribe(new SafeEmitter(emitter)));
    }

    static {
        DECORATORS.add(FailureExceptionConverter.getDefault());
    }
}

