/*
 * Decompiled with CFR 0.152.
 */
package digital.bakehouse.rxusecase;

import digital.bakehouse.rxusecase.Failure;
import digital.bakehouse.rxusecase.Response;
import io.reactivex.functions.Consumer;

public class ResponseConsumer<O>
implements Consumer<Response<O>> {
    private Consumer<O> successConsumer;
    private Consumer<Failure> failureConsumer;

    public ResponseConsumer(Consumer<O> successConsumer) {
        this.successConsumer = successConsumer;
    }

    public ResponseConsumer(Consumer<O> successConsumer, Consumer<Failure> failureConsumer) {
        this.successConsumer = successConsumer;
        this.failureConsumer = failureConsumer;
    }

    public void accept(Response<O> response) throws Exception {
        if (response.isSuccessful()) {
            if (this.successConsumer != null) {
                this.successConsumer.accept(response.getData());
            }
        } else if (this.failureConsumer != null) {
            this.failureConsumer.accept((Object)response.getFailure());
        }
    }

    public static <O> ResponseConsumer<O> consumeSuccess(Consumer<O> successConsumer) {
        return new ResponseConsumer<O>(successConsumer);
    }

    public static <O> ResponseConsumer<O> consumeFailure(Consumer<Failure> failureConsumer) {
        return new ResponseConsumer<O>(null, failureConsumer);
    }

    public static <O> ResponseConsumer<O> consume(Consumer<O> successConsumer, Consumer<Failure> failureConsumer) {
        return new ResponseConsumer<O>(successConsumer, failureConsumer);
    }
}

