/*
 * Decompiled with CFR 0.152.
 */
package digital.bakehouse.rxusecase;

import digital.bakehouse.rxusecase.Failure;
import digital.bakehouse.rxusecase.toolbox.Objects;

public class Response<O> {
    private O data;
    private Failure failure;

    public Response(O data, Failure failure) {
        this.data = data;
        this.failure = failure;
    }

    public O getData() {
        return this.data;
    }

    public Failure getFailure() {
        return this.failure;
    }

    public boolean isSuccessful() {
        return this.failure == null;
    }

    public static <O> Response<O> succeed(O output) {
        return new Response<O>(output, null);
    }

    public static <O> Response<O> fail(Failure failure) {
        return new Response<Object>(null, failure);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Response response = (Response)o;
        return Objects.equals(this.data, response.data) && Objects.equals(this.failure, response.failure);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.failure);
    }

    public String toString() {
        return "Response{data=" + this.data + ", failure=" + this.failure + '}';
    }
}

