/*
 * Decompiled with CFR 0.152.
 */
package digital.bakehouse.rxusecase;

import digital.bakehouse.rxusecase.toolbox.Objects;

public class Request<I> {
    private I input;
    private Object tag;
    private String origin;

    private Request(Builder<I> builder) {
        this.input = ((Builder)builder).input;
        this.tag = ((Builder)builder).tag;
    }

    public I getInput() {
        return this.input;
    }

    public Object getTag() {
        return this.tag;
    }

    Request<I> origin(String origin) {
        this.origin = origin;
        return this;
    }

    public String getOrigin() {
        return this.origin;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Request request = (Request)o;
        return Objects.equals(this.input, request.input) && Objects.equals(this.tag, request.tag) && Objects.equals(this.origin, request.origin);
    }

    public int hashCode() {
        return Objects.hash(this.input, this.tag, this.origin);
    }

    public String toString() {
        return "Request{input=" + this.input + ", tag=" + this.tag + ", origin='" + this.origin + '\'' + '}';
    }

    public static <I> Builder<I> newBuilder(I input) {
        return new Builder<I>(input);
    }

    public static class Builder<I> {
        private I input;
        private Object tag;

        Builder(I input) {
            this.input = input;
        }

        public Builder<I> tag(Object tag) {
            this.tag = tag;
            return this;
        }

        public Request<I> build() {
            return new Request(this);
        }
    }
}

