/*
 * Decompiled with CFR 0.152.
 */
package devcsrj.okhttp3.logging;

import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import okhttp3.Connection;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpLoggingInterceptor
implements Interceptor {
    public static final String DEFAULT_LOGGER_NAME = "okhttp3.logging.wire";
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final Logger DEFAULT_LOGGER = LoggerFactory.getLogger((String)"okhttp3.logging.wire");
    private final Logger logger;

    public HttpLoggingInterceptor() {
        this(DEFAULT_LOGGER);
    }

    public HttpLoggingInterceptor(Logger logger) {
        if (logger == null) {
            throw new IllegalArgumentException("Can't use null logger");
        }
        this.logger = logger;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response;
        boolean logBody = this.logger.isDebugEnabled();
        boolean logHeaders = logBody || this.logger.isInfoEnabled();
        Request request = chain.request();
        RequestBody requestBody = request.body();
        boolean hasRequestBody = requestBody != null;
        Connection connection = chain.connection();
        Protocol protocol = connection != null ? connection.protocol() : Protocol.HTTP_1_1;
        this.logger.info("--> {} {} {}", new Object[]{request.method(), request.url(), protocol});
        if (logHeaders) {
            if (hasRequestBody) {
                if (requestBody.contentType() != null) {
                    this.logger.info("Content-Type: {}", (Object)requestBody.contentType());
                }
                if (requestBody.contentLength() != -1L) {
                    this.logger.info("Content-Length: {}", (Object)requestBody.contentLength());
                }
            }
            Headers headers = request.headers();
            for (int i = 0; i < headers.size(); ++i) {
                String name = headers.name(i);
                if ("Content-Type".equalsIgnoreCase(name) || "Content-Length".equalsIgnoreCase(name)) continue;
                this.logger.info("{}: {}", (Object)name, (Object)headers.value(i));
            }
            if (!logBody || !hasRequestBody) {
                this.logger.info("--> END {}", (Object)request.method());
            } else if (this.bodyEncoded(request.headers())) {
                this.logger.info("--> END {} (encoded body omitted)", (Object)request.method());
            } else {
                Buffer buffer = new Buffer();
                requestBody.writeTo((BufferedSink)buffer);
                Charset charset = UTF8;
                MediaType contentType = requestBody.contentType();
                if (contentType != null) {
                    charset = contentType.charset(UTF8);
                }
                this.logger.debug("");
                if (HttpLoggingInterceptor.isPlaintext(buffer)) {
                    this.logger.debug(buffer.readString(charset));
                    this.logger.debug("--> END {} ({}-byte body)", (Object)request.method(), (Object)requestBody.contentLength());
                } else {
                    this.logger.debug("--> END {} (binary {}-byte body omitted", (Object)request.method(), (Object)requestBody.contentLength());
                }
            }
        }
        long startNs = System.nanoTime();
        try {
            response = chain.proceed(request);
        }
        catch (Exception e) {
            this.logger.info("<-- HTTP FAILED: " + e);
            throw e;
        }
        long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
        ResponseBody responseBody = response.body();
        long contentLength = responseBody.contentLength();
        String bodySize = contentLength != -1L ? contentLength + "-byte" : "unknown-length";
        this.logger.info("<-- {} {} {} (took {} ms {})", new Object[]{response.code(), response.message(), response.request().url(), tookMs, !logHeaders ? ", " + bodySize + " body" : ""});
        if (logHeaders) {
            Headers headers = response.headers();
            for (int i = 0; i < headers.size(); ++i) {
                this.logger.info("{}: {}", (Object)headers.name(i), (Object)headers.value(i));
            }
            if (!logBody || !HttpLoggingInterceptor.hasBody(response)) {
                this.logger.info("<-- END HTTP");
            } else if (this.bodyEncoded(headers)) {
                this.logger.info("<-- END HTTP (encoded body omitted)");
            } else {
                BufferedSource source = responseBody.source();
                source.request(Long.MAX_VALUE);
                Buffer buffer = source.buffer();
                Charset charset = UTF8;
                MediaType contentType = responseBody.contentType();
                if (contentType != null) {
                    charset = contentType.charset(UTF8);
                }
                if (!HttpLoggingInterceptor.isPlaintext(buffer)) {
                    this.logger.debug("");
                    this.logger.debug("<-- END HTTP (binary {}-byte body omitted)", (Object)buffer.size());
                    return response;
                }
                if (contentLength != 0L) {
                    this.logger.debug("");
                    this.logger.debug(buffer.clone().readString(charset));
                }
                this.logger.debug("<-- END HTTP ({}-byte body)", (Object)buffer.size());
            }
        }
        return response;
    }

    static boolean isPlaintext(Buffer buffer) {
        try {
            Buffer prefix = new Buffer();
            long byteCount = buffer.size() < 64L ? buffer.size() : 64L;
            buffer.copyTo(prefix, 0L, byteCount);
            for (int i = 0; i < 16 && !prefix.exhausted(); ++i) {
                int codePoint = prefix.readUtf8CodePoint();
                if (!Character.isISOControl(codePoint) || Character.isWhitespace(codePoint)) continue;
                return false;
            }
            return true;
        }
        catch (EOFException e) {
            return false;
        }
    }

    static boolean hasBody(Response response) {
        if (response.request().method().equals("HEAD")) {
            return false;
        }
        int responseCode = response.code();
        if ((responseCode < 100 || responseCode >= 200) && responseCode != 204 && responseCode != 304) {
            return true;
        }
        return HttpLoggingInterceptor.contentLength(response) != -1L || "chunked".equalsIgnoreCase(response.header("Transfer-Encoding"));
    }

    static long contentLength(Response response) {
        return HttpLoggingInterceptor.contentLength(response.headers());
    }

    static long contentLength(Headers headers) {
        return HttpLoggingInterceptor.stringToLong(headers.get("Content-Length"));
    }

    private static long stringToLong(String s) {
        if (s == null) {
            return -1L;
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    private boolean bodyEncoded(Headers headers) {
        String contentEncoding = headers.get("Content-Encoding");
        return contentEncoding != null && !contentEncoding.equalsIgnoreCase("identity");
    }
}

