/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zos3270.spi;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.galasa.ResultArchiveStoreContentType;
import dev.galasa.SetContentType;
import dev.galasa.framework.spi.IConfidentialTextService;
import dev.galasa.framework.spi.IFramework;
import dev.galasa.zos.IZosImage;
import dev.galasa.zos3270.AttentionIdentification;
import dev.galasa.zos3270.IScreenUpdateListener;
import dev.galasa.zos3270.TerminalInterruptedException;
import dev.galasa.zos3270.Zos3270ManagerException;
import dev.galasa.zos3270.common.screens.FieldContents;
import dev.galasa.zos3270.common.screens.TerminalField;
import dev.galasa.zos3270.common.screens.TerminalImage;
import dev.galasa.zos3270.common.screens.TerminalSize;
import dev.galasa.zos3270.internal.properties.ApplyConfidentialTextFiltering;
import dev.galasa.zos3270.internal.properties.LiveTerminalUrl;
import dev.galasa.zos3270.internal.properties.LogConsoleTerminals;
import dev.galasa.zos3270.internal.properties.TerminalDeviceTypes;
import dev.galasa.zos3270.spi.Field;
import dev.galasa.zos3270.spi.Screen;
import dev.galasa.zos3270.spi.Terminal;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Zos3270TerminalImpl
extends Terminal
implements IScreenUpdateListener {
    private Log logger = LogFactory.getLog(this.getClass());
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final String terminalId;
    private int updateId;
    private final String runId;
    private final IConfidentialTextService cts;
    private final boolean applyCtf;
    private final ArrayList<TerminalImage> cachedImages = new ArrayList();
    private final Path terminalRasDirectory;
    private int rasTerminalSequence;
    private URL liveTerminalUrl;
    private int liveTerminalSequence;
    private boolean logConsoleTerminals;
    private boolean autoConnect;

    public Zos3270TerminalImpl(String id, String host, int port, boolean tls, IFramework framework, boolean autoConnect, IZosImage image) throws Zos3270ManagerException, TerminalInterruptedException {
        this(id, host, port, tls, framework, autoConnect, image, 80, 24, 0, 0);
    }

    public Zos3270TerminalImpl(String id, String host, int port, boolean tls, IFramework framework, boolean autoConnect, IZosImage image, int primaryColumns, int primaryRows, int alternateColumns, int alternateRows) throws Zos3270ManagerException, TerminalInterruptedException {
        super(id, host, port, tls, primaryColumns, primaryRows, alternateColumns, alternateRows);
        this.terminalId = id;
        this.runId = framework.getTestRunName();
        this.autoConnect = autoConnect;
        this.cts = framework.getConfidentialTextService();
        this.applyCtf = ApplyConfidentialTextFiltering.get();
        this.getScreen().registerScreenUpdateListener(this);
        Path storedArtifactsRoot = framework.getResultArchiveStore().getStoredArtifactsRoot();
        this.terminalRasDirectory = storedArtifactsRoot.resolve("zos3270").resolve("terminals").resolve(this.terminalId);
        URL propLiveTerminalUrl = LiveTerminalUrl.get();
        if (propLiveTerminalUrl == null) {
            this.liveTerminalUrl = null;
        } else {
            try {
                HttpURLConnection connection = (HttpURLConnection)propLiveTerminalUrl.openConnection();
                connection.setRequestMethod("HEAD");
                connection.addRequestProperty("zos3270-runid", this.runId);
                connection.addRequestProperty("zos3270-terminalid", this.terminalId);
                connection.setDoInput(true);
                connection.setDoOutput(false);
                connection.connect();
                if (connection.getResponseCode() != 200) {
                    this.logger.warn((Object)("Unable to activate live terminal due to " + connection.getResponseCode() + " - " + connection.getResponseMessage()));
                } else {
                    this.liveTerminalUrl = new URL(propLiveTerminalUrl.toString() + "/" + this.runId + "/" + this.terminalId);
                }
            }
            catch (Exception e) {
                throw new Zos3270ManagerException("Unable to create the live terminal directory", e);
            }
        }
        this.setDeviceTypes(TerminalDeviceTypes.get(image));
        this.logConsoleTerminals = LogConsoleTerminals.get();
    }

    public boolean doAutoConnect() {
        return this.autoConnect;
    }

    @Override
    public synchronized void screenUpdated(IScreenUpdateListener.Direction direction, AttentionIdentification aid) {
        String aidString;
        ++this.updateId;
        String update = this.terminalId + "-" + this.updateId;
        String aidText = null;
        if (aid != null) {
            aidString = ", " + aid.toString();
            aidText = aid.toString();
        } else {
            aidString = " update";
        }
        int cursorPosition = this.getScreen().getCursor();
        int screenCols = this.getScreen().getNoOfColumns();
        int screenRows = this.getScreen().getNoOfRows();
        int cursorRow = cursorPosition / screenRows;
        int cursorCol = cursorPosition % screenCols;
        TerminalSize terminalSize = new TerminalSize(screenCols, screenRows);
        TerminalImage terminalImage = new TerminalImage(this.updateId, update, direction == IScreenUpdateListener.Direction.RECEIVED, null, aidText, terminalSize, cursorCol, cursorRow);
        terminalImage.getFields().addAll(Zos3270TerminalImpl.buildTerminalFields(this.getScreen()));
        this.cachedImages.add(terminalImage);
        if (this.cachedImages.size() >= 10) {
            this.flushTerminalCache();
        }
        if (this.liveTerminalUrl != null) {
            try {
                ++this.liveTerminalSequence;
                dev.galasa.zos3270.common.screens.Terminal liveTerminal = new dev.galasa.zos3270.common.screens.Terminal(this.terminalId, this.runId, this.liveTerminalSequence, terminalSize);
                liveTerminal.getImages().add(terminalImage);
                JsonObject intermediateJson = (JsonObject)this.gson.toJsonTree((Object)liveTerminal);
                Zos3270TerminalImpl.stripFalseBooleans(intermediateJson);
                String tempJson = this.gson.toJson((JsonElement)intermediateJson);
                if (this.applyCtf) {
                    tempJson = this.cts.removeConfidentialText(tempJson);
                }
                HttpURLConnection connection = (HttpURLConnection)this.liveTerminalUrl.openConnection();
                connection.setRequestMethod("PUT");
                connection.addRequestProperty("Content-Type", "application/json");
                connection.setDoInput(true);
                connection.setDoOutput(true);
                connection.connect();
                try (OutputStream os = connection.getOutputStream();){
                    IOUtils.write((String)tempJson, (OutputStream)os, (Charset)StandardCharsets.UTF_8);
                }
                if (connection.getResponseCode() != 200) {
                    this.logger.warn((Object)("Unable to write live terminal due to " + connection.getResponseCode() + " - " + connection.getResponseMessage()));
                    this.liveTerminalUrl = null;
                }
            }
            catch (Exception e) {
                this.logger.error((Object)"Failed to write live terminal image, image lost", (Throwable)e);
                this.liveTerminalUrl = null;
            }
        }
        if (this.logConsoleTerminals) {
            String screenData = this.getScreen().printScreenTextWithCursor();
            if (this.applyCtf) {
                screenData = this.cts.removeConfidentialText(screenData);
            }
            this.logger.debug((Object)(direction.toString() + aidString + " to 3270 terminal " + this.terminalId + ",  updateId=" + update + "\n" + screenData));
        } else {
            this.logger.debug((Object)(direction.toString() + aidString + " to 3270 terminal " + this.terminalId + ",  updateId=" + update));
        }
    }

    public synchronized void flushTerminalCache() {
        if (this.cachedImages.isEmpty()) {
            return;
        }
        ++this.rasTerminalSequence;
        try {
            TerminalSize terminalSize = new TerminalSize(this.getScreen().getNoOfColumns(), this.getScreen().getNoOfRows());
            dev.galasa.zos3270.common.screens.Terminal rasTerminal = new dev.galasa.zos3270.common.screens.Terminal(this.terminalId, this.runId, this.rasTerminalSequence, terminalSize);
            rasTerminal.getImages().addAll(this.cachedImages);
            JsonObject intermediateJson = (JsonObject)this.gson.toJsonTree((Object)rasTerminal);
            Zos3270TerminalImpl.stripFalseBooleans(intermediateJson);
            String tempJson = this.gson.toJson((JsonElement)intermediateJson);
            if (this.applyCtf) {
                tempJson = this.cts.removeConfidentialText(tempJson);
            }
            String terminalFilename = this.terminalId + "-" + String.format("%05d", this.rasTerminalSequence) + ".gz";
            Path terminalPath = this.terminalRasDirectory.resolve(terminalFilename);
            try (GZIPOutputStream gos = new GZIPOutputStream(Files.newOutputStream(terminalPath, new OpenOption[]{new SetContentType(new ResultArchiveStoreContentType("application/zos3270terminal")), StandardOpenOption.CREATE}));){
                IOUtils.write((String)tempJson, (OutputStream)gos, (String)"utf-8");
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to write terminal cache to the RAS", (Throwable)e);
            --this.rasTerminalSequence;
            return;
        }
        this.cachedImages.clear();
    }

    private static List<TerminalField> buildTerminalFields(Screen screen) {
        Field[] screenFields;
        ArrayList<TerminalField> terminalFields = new ArrayList<TerminalField>();
        for (Field screenField : screenFields = screen.calculateFields()) {
            int row = screenField.getStart() / screen.getNoOfColumns();
            int column = screenField.getStart() % screen.getNoOfColumns();
            TerminalField terminalField = new TerminalField(row, column, screenField.isUnformatted(), screenField.isProtected(), screenField.isNumeric(), screenField.isDisplay(), screenField.isIntenseDisplay(), screenField.isSelectorPen(), screenField.isFieldModifed());
            Character[] chars = screenField.getFieldCharsWithNulls();
            terminalField.getContents().add(new FieldContents(chars));
            terminalFields.add(terminalField);
        }
        return terminalFields;
    }

    @Override
    public String getId() {
        return this.terminalId;
    }

    public static void stripFalseBooleans(JsonObject json) {
        ArrayList entries = new ArrayList();
        entries.addAll(json.entrySet());
        for (Map.Entry entry : entries) {
            JsonElement element = (JsonElement)entry.getValue();
            if (element.isJsonPrimitive() && ((JsonPrimitive)element).isBoolean() && !((JsonPrimitive)element).getAsBoolean()) {
                json.remove((String)entry.getKey());
                continue;
            }
            if (element.isJsonObject()) {
                Zos3270TerminalImpl.stripFalseBooleans((JsonObject)element);
                continue;
            }
            if (!element.isJsonArray()) continue;
            JsonArray array = (JsonArray)element;
            for (int i = 0; i < array.size(); ++i) {
                if (!array.get(i).isJsonObject()) continue;
                Zos3270TerminalImpl.stripFalseBooleans((JsonObject)array.get(i));
            }
        }
    }
}

