/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zos3270.spi;

import dev.galasa.zos3270.AttentionIdentification;
import dev.galasa.zos3270.ErrorTextFoundException;
import dev.galasa.zos3270.FieldNotFoundException;
import dev.galasa.zos3270.IDatastreamListener;
import dev.galasa.zos3270.ITerminal;
import dev.galasa.zos3270.KeyboardLockedException;
import dev.galasa.zos3270.TerminalInterruptedException;
import dev.galasa.zos3270.TextNotFoundException;
import dev.galasa.zos3270.TimeoutException;
import dev.galasa.zos3270.Zos3270Exception;
import dev.galasa.zos3270.internal.comms.Network;
import dev.galasa.zos3270.internal.comms.NetworkThread;
import dev.galasa.zos3270.spi.Field;
import dev.galasa.zos3270.spi.NetworkException;
import dev.galasa.zos3270.spi.Screen;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Terminal
implements ITerminal {
    private final Screen screen;
    private final Network network;
    private final String id;
    private NetworkThread networkThread;
    private boolean connected = false;
    private int defaultWaitTime = 120000;
    private Log logger = LogFactory.getLog(this.getClass());
    private boolean autoReconnect = false;
    private List<String> deviceTypes;

    public Terminal(String id, String host, int port) throws TerminalInterruptedException {
        this(id, host, port, false, 80, 24, 0, 0);
    }

    public Terminal(String id, String host, int port, boolean ssl) throws TerminalInterruptedException {
        this(id, host, port, ssl, 80, 24, 0, 0);
    }

    public Terminal(String id, String host, int port, boolean ssl, int primaryColumns, int primaryRows, int alternateColumns, int alternateRows) throws TerminalInterruptedException {
        this.network = new Network(host, port, ssl, id);
        this.screen = new Screen(primaryColumns, primaryRows, alternateColumns, alternateRows, this.network);
        this.id = id;
    }

    public void setAutoReconnect(boolean newAutoReconnect) {
        this.autoReconnect = newAutoReconnect;
    }

    public void setDeviceTypes(List<String> deviceTypes) {
        this.deviceTypes = deviceTypes;
    }

    @Override
    public synchronized void connect() throws NetworkException {
        this.connected = this.network.connectClient();
        this.networkThread = new NetworkThread(this, this.screen, this.network, this.network.getInputStream(), this.deviceTypes);
        this.networkThread.start();
        Instant expire = Instant.now().plus(60L, ChronoUnit.SECONDS);
        boolean started = false;
        while (Instant.now().isBefore(expire)) {
            NetworkThread nThread = this.networkThread;
            if (nThread == null) {
                this.network.close();
                throw new NetworkException("The TN3270 network thread failed to start correctly");
            }
            if (nThread.isStarted()) {
                started = true;
                break;
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new NetworkException("Wait for TN3270 startup was interrupted", e);
            }
        }
        if (!started) {
            throw new NetworkException("TN3270 server did not start session in time");
        }
    }

    @Override
    public void disconnect() throws TerminalInterruptedException {
        boolean oldAutoReconnect = this.autoReconnect;
        this.autoReconnect = false;
        this.connected = false;
        if (this.network != null) {
            this.network.close();
        }
        if (this.networkThread != null) {
            try {
                this.networkThread.join();
            }
            catch (InterruptedException e) {
                throw new TerminalInterruptedException("Join of the network thread was interrupted", e);
            }
            this.networkThread = null;
        }
        this.autoReconnect = oldAutoReconnect;
    }

    public void networkClosed() {
        this.connected = false;
        if (this.network != null) {
            this.network.close();
        }
        this.networkThread = null;
        if (this.autoReconnect) {
            try {
                this.connect();
            }
            catch (NetworkException e) {
                this.logger.error((Object)"Auto reconnect failed", (Throwable)e);
            }
        }
    }

    @Override
    public boolean isConnected() {
        if (!this.connected) {
            return false;
        }
        if (this.network == null) {
            return false;
        }
        return this.network.isConnected();
    }

    @Override
    public ITerminal waitForKeyboard() throws TimeoutException, KeyboardLockedException, TerminalInterruptedException {
        this.logger.trace((Object)"Waiting for keyboard");
        this.screen.waitForKeyboard(this.defaultWaitTime);
        this.logger.trace((Object)"Wait for keyboard complete");
        return this;
    }

    @Override
    public ITerminal wfk() throws TimeoutException, KeyboardLockedException, TerminalInterruptedException {
        return this.waitForKeyboard();
    }

    public Screen getScreen() {
        return this.screen;
    }

    @Override
    public ITerminal positionCursorToFieldContaining(@NotNull String text) throws TextNotFoundException, KeyboardLockedException {
        this.screen.positionCursorToFieldContaining(text);
        return this;
    }

    @Override
    public Terminal verifyTextInField(String text) throws TextNotFoundException {
        this.screen.searchFieldContaining(text);
        return this;
    }

    @Override
    public boolean isTextInField(String text) {
        return this.screen.isTextInField(text);
    }

    @Override
    public boolean isTextInField(String text, long timeoutInMilliseconds) throws TerminalInterruptedException {
        if (this.isTextInField(text)) {
            return true;
        }
        Instant expire = Instant.now().plus(timeoutInMilliseconds, ChronoUnit.MILLIS);
        while (expire.isAfter(Instant.now())) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new TerminalInterruptedException("Wait for text was interrupted", e);
            }
            if (!this.isTextInField(text)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ITerminal waitForTextInField(String text) throws TerminalInterruptedException, TextNotFoundException, Zos3270Exception {
        this.screen.waitForTextInField(text, this.defaultWaitTime);
        return this;
    }

    @Override
    public int waitForTextInField(String[] ok, String[] error) throws TerminalInterruptedException, TextNotFoundException, ErrorTextFoundException, Zos3270Exception {
        return this.waitForTextInField(ok, error, this.defaultWaitTime);
    }

    @Override
    public int waitForTextInField(String[] ok, String[] error, long timeoutInMilliseconds) throws TerminalInterruptedException, TextNotFoundException, ErrorTextFoundException, Zos3270Exception {
        return this.screen.waitForTextInField(ok, error, timeoutInMilliseconds);
    }

    @Override
    public ITerminal type(String text) throws KeyboardLockedException, FieldNotFoundException {
        this.screen.type(text);
        return this;
    }

    @Override
    public ITerminal eraseEof() throws KeyboardLockedException, FieldNotFoundException {
        this.screen.eraseEof();
        return this;
    }

    @Override
    public ITerminal eraseInput() throws KeyboardLockedException, FieldNotFoundException {
        this.screen.eraseInput();
        return this;
    }

    @Override
    public ITerminal tab() throws KeyboardLockedException, FieldNotFoundException {
        this.screen.tab();
        return this;
    }

    @Override
    public ITerminal backTab() throws KeyboardLockedException, FieldNotFoundException {
        this.screen.backTab();
        return this;
    }

    @Override
    public ITerminal cursorUp() throws KeyboardLockedException, FieldNotFoundException {
        this.screen.cursorUp();
        return this;
    }

    @Override
    public ITerminal cursorDown() throws KeyboardLockedException, FieldNotFoundException {
        this.screen.cursorDown();
        return this;
    }

    @Override
    public ITerminal cursorLeft() throws KeyboardLockedException, FieldNotFoundException {
        this.screen.cursorLeft();
        return this;
    }

    @Override
    public ITerminal cursorRight() throws KeyboardLockedException, FieldNotFoundException {
        this.screen.cursorRight();
        return this;
    }

    @Override
    public ITerminal home() throws KeyboardLockedException, FieldNotFoundException {
        this.screen.home();
        return this;
    }

    @Override
    public ITerminal newLine() throws KeyboardLockedException, FieldNotFoundException {
        this.screen.newLine();
        return this;
    }

    @Override
    public ITerminal backSpace() throws KeyboardLockedException, FieldNotFoundException {
        this.screen.backSpace();
        return this;
    }

    @Override
    public ITerminal enter() throws KeyboardLockedException, NetworkException, TerminalInterruptedException {
        this.network.sendDatastream(this.screen.aid(AttentionIdentification.ENTER));
        return this;
    }

    @Override
    public ITerminal clear() throws KeyboardLockedException, NetworkException, TerminalInterruptedException {
        this.network.sendDatastream(this.screen.aid(AttentionIdentification.CLEAR));
        return this;
    }

    @Override
    public ITerminal pf1() throws KeyboardLockedException, NetworkException, TerminalInterruptedException {
        this.network.sendDatastream(this.screen.aid(AttentionIdentification.PF1));
        return this;
    }

    @Override
    public ITerminal pf2() throws KeyboardLockedException, NetworkException, TerminalInterruptedException {
        this.network.sendDatastream(this.screen.aid(AttentionIdentification.PF2));
        return this;
    }

    @Override
    public ITerminal pf3() throws KeyboardLockedException, NetworkException, TerminalInterruptedException {
        this.network.sendDatastream(this.screen.aid(AttentionIdentification.PF3));
        return this;
    }

    @Override
    public ITerminal pf4() throws KeyboardLockedException, NetworkException, TerminalInterruptedException {
        this.network.sendDatastream(this.screen.aid(AttentionIdentification.PF4));
        return this;
    }

    @Override
    public ITerminal pf5() throws KeyboardLockedException, NetworkException, TerminalInterruptedException {
        this.network.sendDatastream(this.screen.aid(AttentionIdentification.PF5));
        return this;
    }

    @Override
    public ITerminal pf6() throws KeyboardLockedException, NetworkException, TerminalInterruptedException {
        this.network.sendDatastream(this.screen.aid(AttentionIdentification.PF6));
        return this;
    }

    @Override
    public ITerminal pf7() throws KeyboardLockedException, NetworkException, TerminalInterruptedException {
        this.network.sendDatastream(this.screen.aid(AttentionIdentification.PF7));
        return this;
    }

    @Override
    public ITerminal pf8() throws KeyboardLockedException, NetworkException, TerminalInterruptedException {
        this.network.sendDatastream(this.screen.aid(AttentionIdentification.PF8));
        return this;
    }

    @Override
    public ITerminal pf9() throws KeyboardLockedException, NetworkException, TerminalInterruptedException {
        this.network.sendDatastream(this.screen.aid(AttentionIdentification.PF9));
        return this;
    }

    @Override
    public ITerminal pf10() throws KeyboardLockedException, NetworkException, TerminalInterruptedException {
        this.network.sendDatastream(this.screen.aid(AttentionIdentification.PF10));
        return this;
    }

    @Override
    public ITerminal pf11() throws KeyboardLockedException, NetworkException, TerminalInterruptedException {
        this.network.sendDatastream(this.screen.aid(AttentionIdentification.PF11));
        return this;
    }

    @Override
    public ITerminal pf12() throws KeyboardLockedException, NetworkException, TerminalInterruptedException {
        this.network.sendDatastream(this.screen.aid(AttentionIdentification.PF12));
        return this;
    }

    @Override
    public ITerminal pf13() throws KeyboardLockedException, NetworkException, TerminalInterruptedException {
        this.network.sendDatastream(this.screen.aid(AttentionIdentification.PF13));
        return this;
    }

    @Override
    public ITerminal pf14() throws KeyboardLockedException, NetworkException, TerminalInterruptedException {
        this.network.sendDatastream(this.screen.aid(AttentionIdentification.PF14));
        return this;
    }

    @Override
    public ITerminal pf15() throws KeyboardLockedException, NetworkException, TerminalInterruptedException {
        this.network.sendDatastream(this.screen.aid(AttentionIdentification.PF15));
        return this;
    }

    @Override
    public ITerminal pf16() throws KeyboardLockedException, NetworkException, TerminalInterruptedException {
        this.network.sendDatastream(this.screen.aid(AttentionIdentification.PF16));
        return this;
    }

    @Override
    public ITerminal pf17() throws KeyboardLockedException, NetworkException, TerminalInterruptedException {
        this.network.sendDatastream(this.screen.aid(AttentionIdentification.PF17));
        return this;
    }

    @Override
    public ITerminal pf18() throws KeyboardLockedException, NetworkException, TerminalInterruptedException {
        this.network.sendDatastream(this.screen.aid(AttentionIdentification.PF18));
        return this;
    }

    @Override
    public ITerminal pf19() throws KeyboardLockedException, NetworkException, TerminalInterruptedException {
        this.network.sendDatastream(this.screen.aid(AttentionIdentification.PF19));
        return this;
    }

    @Override
    public ITerminal pf20() throws KeyboardLockedException, NetworkException, TerminalInterruptedException {
        this.network.sendDatastream(this.screen.aid(AttentionIdentification.PF20));
        return this;
    }

    @Override
    public ITerminal pf21() throws KeyboardLockedException, NetworkException, TerminalInterruptedException {
        this.network.sendDatastream(this.screen.aid(AttentionIdentification.PF21));
        return this;
    }

    @Override
    public ITerminal pf22() throws KeyboardLockedException, NetworkException, TerminalInterruptedException {
        this.network.sendDatastream(this.screen.aid(AttentionIdentification.PF22));
        return this;
    }

    @Override
    public ITerminal pf23() throws KeyboardLockedException, NetworkException, TerminalInterruptedException {
        this.network.sendDatastream(this.screen.aid(AttentionIdentification.PF23));
        return this;
    }

    @Override
    public ITerminal pf24() throws KeyboardLockedException, NetworkException, TerminalInterruptedException {
        this.network.sendDatastream(this.screen.aid(AttentionIdentification.PF24));
        return this;
    }

    @Override
    public ITerminal pa1() throws KeyboardLockedException, NetworkException, TerminalInterruptedException {
        this.network.sendDatastream(this.screen.aid(AttentionIdentification.PA1));
        return this;
    }

    @Override
    public ITerminal pa2() throws KeyboardLockedException, NetworkException, TerminalInterruptedException {
        this.network.sendDatastream(this.screen.aid(AttentionIdentification.PA2));
        return this;
    }

    @Override
    public ITerminal pa3() throws KeyboardLockedException, NetworkException, TerminalInterruptedException {
        this.network.sendDatastream(this.screen.aid(AttentionIdentification.PA3));
        return this;
    }

    @Override
    public ITerminal reportScreen() {
        this.logger.info((Object)("\n" + this.screen.printScreen()));
        return this;
    }

    @Override
    public ITerminal reportScreenWithCursor() {
        this.logger.info((Object)("\n" + this.screen.printScreenTextWithCursor()));
        return this;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String retrieveScreen() {
        return this.screen.printScreen();
    }

    @Override
    public String retrieveFieldAtCursor() {
        int cursorPos = this.screen.getCursor();
        Field cursorField = this.screen.locateFieldAt(cursorPos);
        return cursorField.getFieldWithoutNulls();
    }

    @Override
    public String retrieveFieldTextAfterFieldWithString(String fieldName) throws TextNotFoundException {
        return this.screen.getValueFromFieldContaining(fieldName);
    }

    public String getHostPort() {
        return this.network.getHostPort();
    }

    @Override
    public void registerDatastreamListener(IDatastreamListener listener) {
        this.screen.registerDatastreamListener(listener);
    }

    @Override
    public void unregisterDatastreamListener(IDatastreamListener listener) {
        this.screen.unregisterDatastreamListener(listener);
    }

    @Override
    public boolean isSwitchedSSL() {
        return this.network.isSwitchedSSL();
    }

    @Override
    public void setDoStartTls(boolean doStartTls) {
        this.network.setDoStartTls(doStartTls);
    }

    @Override
    public boolean isClearScreen() {
        return this.screen.isClearScreen();
    }

    @Override
    public void setCursorPosition(int row, int col) throws KeyboardLockedException, Zos3270Exception {
        this.checkCursorPosition(row, col, 0);
        this.screen.setCursorPosition(--col, --row);
    }

    @Override
    public String retrieveText(int row, int col, int length) throws Zos3270Exception {
        this.checkCursorPosition(row, col, length);
        String textScreen = this.screen.retrieveFlatScreen();
        int startPos = --row * this.screen.getNoOfColumns() + --col;
        int endPos = startPos + (length - 1);
        return textScreen.substring(startPos, endPos);
    }

    @Override
    public String retrieveTextAtCursor(int length) throws Zos3270Exception {
        int pos = this.screen.getCursor();
        if (pos + length > this.screen.getScreenSize()) {
            throw new Zos3270Exception("Invalid length, it would exceed the screen buffer");
        }
        String textScreen = this.screen.retrieveFlatScreen();
        int endPos = pos + (length - 1);
        return textScreen.substring(pos, endPos);
    }

    private void checkCursorPosition(int row, int col, int length) throws Zos3270Exception {
        int pos;
        if (row < 1 || col < 1) {
            throw new Zos3270Exception("Invalid cursor position, row and col are index based 1");
        }
        int rows = this.screen.getNoOfRows();
        if (row > rows) {
            throw new Zos3270Exception("Invalid cursor position, row exceeds number of rows (" + rows + ")");
        }
        int cols = this.screen.getNoOfColumns();
        if (col > cols) {
            throw new Zos3270Exception("Invalid cursor position, col exceeds number of columns (" + cols + ")");
        }
        if ((pos = --row * this.screen.getNoOfColumns() + --col) + length > this.screen.getScreenSize()) {
            throw new Zos3270Exception("Invalid length, it would exceed the screen buffer");
        }
    }
}

