/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zos3270.spi;

import dev.galasa.zos3270.AttentionIdentification;
import dev.galasa.zos3270.ErrorTextFoundException;
import dev.galasa.zos3270.FieldNotFoundException;
import dev.galasa.zos3270.IDatastreamListener;
import dev.galasa.zos3270.IScreenUpdateListener;
import dev.galasa.zos3270.KeyboardLockedException;
import dev.galasa.zos3270.TerminalInterruptedException;
import dev.galasa.zos3270.TextNotFoundException;
import dev.galasa.zos3270.TimeoutException;
import dev.galasa.zos3270.Zos3270Exception;
import dev.galasa.zos3270.internal.comms.Inbound3270Message;
import dev.galasa.zos3270.internal.comms.Network;
import dev.galasa.zos3270.internal.datastream.AbstractCommandCode;
import dev.galasa.zos3270.internal.datastream.AbstractOrder;
import dev.galasa.zos3270.internal.datastream.AbstractQueryReply;
import dev.galasa.zos3270.internal.datastream.BufferAddress;
import dev.galasa.zos3270.internal.datastream.CommandEraseWrite;
import dev.galasa.zos3270.internal.datastream.CommandEraseWriteAlternate;
import dev.galasa.zos3270.internal.datastream.CommandReadBuffer;
import dev.galasa.zos3270.internal.datastream.CommandReadModified;
import dev.galasa.zos3270.internal.datastream.CommandReadModifiedAll;
import dev.galasa.zos3270.internal.datastream.CommandWriteStructured;
import dev.galasa.zos3270.internal.datastream.IAttribute;
import dev.galasa.zos3270.internal.datastream.OrderCarrageReturn;
import dev.galasa.zos3270.internal.datastream.OrderEndOfMedium;
import dev.galasa.zos3270.internal.datastream.OrderEraseUnprotectedToAddress;
import dev.galasa.zos3270.internal.datastream.OrderFormFeed;
import dev.galasa.zos3270.internal.datastream.OrderGraphicsEscape;
import dev.galasa.zos3270.internal.datastream.OrderInsertCursor;
import dev.galasa.zos3270.internal.datastream.OrderNewLine;
import dev.galasa.zos3270.internal.datastream.OrderRepeatToAddress;
import dev.galasa.zos3270.internal.datastream.OrderSetAttribute;
import dev.galasa.zos3270.internal.datastream.OrderSetBufferAddress;
import dev.galasa.zos3270.internal.datastream.OrderStartField;
import dev.galasa.zos3270.internal.datastream.OrderStartFieldExtended;
import dev.galasa.zos3270.internal.datastream.OrderText;
import dev.galasa.zos3270.internal.datastream.QueryReplyCharactersets;
import dev.galasa.zos3270.internal.datastream.QueryReplyColor;
import dev.galasa.zos3270.internal.datastream.QueryReplyHighlite;
import dev.galasa.zos3270.internal.datastream.QueryReplyImplicitPartition;
import dev.galasa.zos3270.internal.datastream.QueryReplyNull;
import dev.galasa.zos3270.internal.datastream.QueryReplySummary;
import dev.galasa.zos3270.internal.datastream.QueryReplyUsableArea;
import dev.galasa.zos3270.internal.datastream.StructuredField;
import dev.galasa.zos3270.internal.datastream.StructuredField3270DS;
import dev.galasa.zos3270.internal.datastream.StructuredFieldReadPartition;
import dev.galasa.zos3270.internal.datastream.WriteControlCharacter;
import dev.galasa.zos3270.internal.terminal.ScreenUpdateTextListener;
import dev.galasa.zos3270.spi.BufferCarrageReturn;
import dev.galasa.zos3270.spi.BufferChar;
import dev.galasa.zos3270.spi.BufferEndOfMedium;
import dev.galasa.zos3270.spi.BufferFormFeed;
import dev.galasa.zos3270.spi.BufferGraphicsEscape;
import dev.galasa.zos3270.spi.BufferNewLine;
import dev.galasa.zos3270.spi.BufferStartOfField;
import dev.galasa.zos3270.spi.DatastreamException;
import dev.galasa.zos3270.spi.Field;
import dev.galasa.zos3270.spi.IBufferHolder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Screen {
    private static final String CANT_FIND_TEXT = "Unable to find a field containing '";
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Network network;
    private boolean usingAlternate;
    private IBufferHolder[] buffer;
    private int screenSize;
    private int columns;
    private int rows;
    private final boolean hasAlternate;
    private final int primaryColumns;
    private final int primaryRows;
    private final int alternateColumns;
    private final int alternateRows;
    private int workingCursor = 0;
    private int screenCursor = 0;
    private Semaphore keyboardLock = new Semaphore(1, true);
    private boolean keyboardLockSet = false;
    private final LinkedList<IDatastreamListener> datastreamListeners = new LinkedList();
    private final LinkedList<IScreenUpdateListener> updateListeners = new LinkedList();
    private AttentionIdentification lastAid = AttentionIdentification.NONE;

    public Screen() throws TerminalInterruptedException {
        this(80, 24, null);
    }

    public Screen(int columns, int rows, Network network) throws TerminalInterruptedException {
        this(columns, rows, 0, 0, network);
    }

    public Screen(int columns, int rows, int alternateColumns, int alternateRows, Network network) throws TerminalInterruptedException {
        this.network = network;
        this.primaryColumns = columns;
        this.primaryRows = rows;
        this.usingAlternate = false;
        if (alternateRows < 1 || alternateColumns < 1) {
            this.hasAlternate = false;
            this.alternateColumns = 0;
            this.alternateRows = 0;
        } else {
            this.hasAlternate = true;
            this.alternateColumns = alternateColumns;
            this.alternateRows = alternateRows;
        }
        this.erase();
        this.lockKeyboard();
    }

    public synchronized void lockKeyboard() throws TerminalInterruptedException {
        if (!this.keyboardLockSet) {
            this.logger.trace((Object)"Locking keyboard");
            this.keyboardLockSet = true;
            try {
                this.keyboardLock.acquire();
            }
            catch (InterruptedException e) {
                throw new TerminalInterruptedException("Lock keyboard was interrupted", e);
            }
        }
    }

    public void networkClosed() throws TerminalInterruptedException {
        this.lockKeyboard();
    }

    private synchronized void unlockKeyboard() {
        if (this.keyboardLockSet) {
            this.logger.trace((Object)"Unlocking keyboard");
            this.keyboardLockSet = false;
            this.keyboardLock.release();
        }
    }

    public synchronized void processInboundMessage(Inbound3270Message inbound) throws DatastreamException {
        AbstractCommandCode commandCode = inbound.getCommandCode();
        if (commandCode instanceof CommandWriteStructured) {
            this.processStructuredFields(inbound.getStructuredFields());
        } else if (commandCode instanceof CommandReadBuffer) {
            this.processReadBuffer();
        } else if (commandCode instanceof CommandReadModified) {
            this.processReadModified(false);
        } else if (commandCode instanceof CommandReadModifiedAll) {
            this.processReadModified(true);
        } else {
            WriteControlCharacter writeControlCharacter = inbound.getWriteControlCharacter();
            List<AbstractOrder> orders = inbound.getOrders();
            if (commandCode instanceof CommandEraseWrite) {
                this.erase();
            } else if (commandCode instanceof CommandEraseWriteAlternate) {
                this.eraseAlternate();
            }
            if (writeControlCharacter.isResetMDT()) {
                this.resetMdt();
            }
            this.workingCursor = this.screenCursor;
            this.processOrders(orders, writeControlCharacter);
        }
    }

    private void resetMdt() {
        for (int i = 0; i < this.screenSize; ++i) {
            IBufferHolder bh = this.buffer[i];
            if (!(bh instanceof BufferStartOfField)) continue;
            BufferStartOfField sof = (BufferStartOfField)bh;
            sof.clearFieldModified();
        }
    }

    private synchronized void processReadBuffer() throws DatastreamException {
        try {
            ByteArrayOutputStream outboundBuffer = new ByteArrayOutputStream();
            outboundBuffer.write(this.lastAid.getKeyValue());
            BufferAddress cursor = new BufferAddress(this.screenCursor);
            outboundBuffer.write(cursor.getCharRepresentation());
            for (IBufferHolder bh : this.buffer) {
                BufferChar bc;
                if (bh == null) {
                    outboundBuffer.write(0);
                    continue;
                }
                if (bh instanceof BufferGraphicsEscape) {
                    bc = (BufferGraphicsEscape)bh;
                    outboundBuffer.write(8);
                    outboundBuffer.write(((BufferGraphicsEscape)bc).getFieldEbcdic());
                    continue;
                }
                if (bh instanceof BufferChar) {
                    bc = (BufferChar)bh;
                    outboundBuffer.write(bc.getFieldEbcdic());
                    continue;
                }
                if (bh instanceof BufferStartOfField) {
                    BufferStartOfField sf = (BufferStartOfField)bh;
                    OrderStartField osf = new OrderStartField(sf.isProtected(), sf.isNumeric(), sf.isDisplay(), sf.isIntenseDisplay(), sf.isSelectorPen(), sf.isFieldModifed());
                    outboundBuffer.write(osf.getBytes());
                    continue;
                }
                throw new DatastreamException("Unrecognised Buffer Holder - " + bh.getClass().getName());
            }
            this.writeTrace(outboundBuffer);
            this.network.sendDatastream(outboundBuffer.toByteArray());
        }
        catch (Exception e) {
            throw new DatastreamException("Error whilst processing READ BUFFER", e);
        }
    }

    private void writeTrace(ByteArrayOutputStream outboundBuffer) {
        if (this.logger.isTraceEnabled() || !this.datastreamListeners.isEmpty()) {
            String hex = new String(Hex.encodeHex((byte[])outboundBuffer.toByteArray()));
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("outbound=" + hex));
            }
            for (IDatastreamListener listener : this.datastreamListeners) {
                listener.datastreamUpdate(IDatastreamListener.DatastreamDirection.OUTBOUND, hex);
            }
        }
    }

    private synchronized void processReadModified(boolean all) throws DatastreamException {
        try {
            ByteArrayOutputStream outboundBuffer = new ByteArrayOutputStream();
            outboundBuffer.write(this.lastAid.getKeyValue());
            if (all || this.lastAid != AttentionIdentification.CLEAR && this.lastAid != AttentionIdentification.PA1 && this.lastAid != AttentionIdentification.PA2 && this.lastAid != AttentionIdentification.PA3) {
                BufferAddress cursor = new BufferAddress(this.screenCursor);
                outboundBuffer.write(cursor.getCharRepresentation());
                this.readModifiedBuffer(outboundBuffer);
            }
            this.writeTrace(outboundBuffer);
            this.network.sendDatastream(outboundBuffer.toByteArray());
        }
        catch (Exception e) {
            throw new DatastreamException("Error whilst processing READ BUFFER", e);
        }
    }

    private void readModifiedBuffer(ByteArrayOutputStream outboundBuffer) throws IOException {
        int start;
        boolean fieldModified = false;
        int end = 0;
        for (start = 0; start < this.buffer.length && !(this.buffer[start] instanceof BufferStartOfField); ++start) {
        }
        if (start >= this.buffer.length) {
            start = 0;
            end = this.buffer.length - 1;
            fieldModified = true;
        } else {
            end = start - 1;
            if (end < 0) {
                end = this.buffer.length - 1;
            }
        }
        int pos = start;
        while (true) {
            BufferChar bc;
            IBufferHolder bh;
            if ((bh = this.buffer[pos]) instanceof BufferStartOfField) {
                BufferStartOfField bsf = (BufferStartOfField)bh;
                fieldModified = bsf.isFieldModifed();
                if (fieldModified) {
                    OrderSetBufferAddress sba = new OrderSetBufferAddress(new BufferAddress(pos + 1));
                    outboundBuffer.write(sba.getCharRepresentation());
                }
            } else if (bh instanceof BufferGraphicsEscape) {
                bc = (BufferGraphicsEscape)bh;
                if (fieldModified) {
                    outboundBuffer.write(8);
                    byte value = ((BufferGraphicsEscape)bc).getFieldEbcdic();
                    outboundBuffer.write(value);
                }
            } else if (bh instanceof BufferChar) {
                byte value;
                bc = (BufferChar)bh;
                if (fieldModified && (value = bc.getFieldEbcdic()) != 0) {
                    outboundBuffer.write(value);
                }
            }
            if (pos == end) break;
            if (++pos < this.buffer.length) continue;
            pos = 0;
        }
    }

    private synchronized void processStructuredFields(List<StructuredField> structuredFields) throws DatastreamException {
        for (StructuredField structuredField : structuredFields) {
            if (structuredField instanceof StructuredFieldReadPartition) {
                this.processReadPartition((StructuredFieldReadPartition)structuredField);
                continue;
            }
            if (structuredField instanceof StructuredField3270DS) {
                this.processInboundMessage(((StructuredField3270DS)structuredField).getInboundMessage());
                continue;
            }
            throw new DatastreamException("Unsupported Structured Field - " + structuredField.getClass().getName());
        }
    }

    private synchronized void processReadPartition(StructuredFieldReadPartition readPartition) throws DatastreamException {
        switch (readPartition.getType()) {
            case QUERY: {
                this.processReadPartitionQuery();
                return;
            }
            case QUERY_LIST: {
                this.processReadPartitionQueryList(readPartition);
                return;
            }
        }
        throw new DatastreamException("Unsupported Read Partition Type - " + readPartition.getType().toString());
    }

    private synchronized void processReadPartitionQuery() throws DatastreamException {
        List<AbstractQueryReply> replies = this.getAllSupportedReplies();
        QueryReplySummary summary = new QueryReplySummary(replies);
        this.sendQueryReplies(summary, replies);
    }

    private synchronized void processReadPartitionQueryList(StructuredFieldReadPartition readPartition) throws DatastreamException {
        switch (readPartition.getRequestType()) {
            case 0: {
                List<AbstractQueryReply> supportedReplies = this.getAllSupportedReplies();
                ArrayList<AbstractQueryReply> replies = this.prepareQueryListResponse(supportedReplies, readPartition.getQcodes());
                this.sendQueryReplies(new QueryReplySummary(supportedReplies), replies);
                return;
            }
            case -128: 
            case 64: {
                this.processReadPartitionQuery();
                return;
            }
        }
        throw new DatastreamException("Unsupported Read Partition Request Type code = " + readPartition.getRequestType());
    }

    private ArrayList<AbstractQueryReply> prepareQueryListResponse(List<AbstractQueryReply> supportedReplies, Set<Byte> requestedQcodes) {
        ArrayList<AbstractQueryReply> replies = new ArrayList<AbstractQueryReply>();
        for (AbstractQueryReply reply : supportedReplies) {
            if (!requestedQcodes.contains(reply.getID())) continue;
            replies.add(reply);
        }
        if (replies.isEmpty()) {
            replies.add(new QueryReplyNull());
        }
        return replies;
    }

    private List<AbstractQueryReply> getAllSupportedReplies() {
        ArrayList<AbstractQueryReply> replies = new ArrayList<AbstractQueryReply>();
        replies.add(new QueryReplyUsableArea(this));
        replies.add(new QueryReplyImplicitPartition(this));
        replies.add(new QueryReplyCharactersets());
        replies.add(new QueryReplyColor());
        replies.add(new QueryReplyHighlite());
        return replies;
    }

    private void sendQueryReplies(QueryReplySummary summary, List<AbstractQueryReply> replies) throws DatastreamException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(AttentionIdentification.STRUCTURED_FIELD.getKeyValue());
            baos.write(summary.toByte());
            for (AbstractQueryReply reply : replies) {
                baos.write(reply.toByte());
            }
            if (this.logger.isTraceEnabled() || !this.datastreamListeners.isEmpty()) {
                String hex = new String(Hex.encodeHex((byte[])baos.toByteArray()));
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("outbound sf=" + hex));
                }
                for (IDatastreamListener listener : this.datastreamListeners) {
                    listener.datastreamUpdate(IDatastreamListener.DatastreamDirection.OUTBOUND, hex);
                }
            }
            this.network.sendDatastream(baos.toByteArray());
        }
        catch (Exception e) {
            throw new DatastreamException("Unable able to write Query Reply", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void processOrders(List<AbstractOrder> orders, WriteControlCharacter writeControlCharacter) throws DatastreamException {
        this.logger.trace((Object)"Processing orders");
        for (AbstractOrder order : orders) {
            if (order instanceof OrderSetBufferAddress) {
                this.processSBA((OrderSetBufferAddress)order);
                continue;
            }
            if (order instanceof OrderRepeatToAddress) {
                this.processRA((OrderRepeatToAddress)order);
                continue;
            }
            if (order instanceof OrderText) {
                this.processText((OrderText)order);
                continue;
            }
            if (order instanceof OrderStartField) {
                this.processSF((OrderStartField)order);
                continue;
            }
            if (order instanceof OrderStartFieldExtended) {
                this.processSFE((OrderStartFieldExtended)order);
                continue;
            }
            if (order instanceof OrderSetAttribute) {
                this.processSA((OrderSetAttribute)order);
                continue;
            }
            if (order instanceof OrderInsertCursor) {
                this.screenCursor = this.workingCursor;
                continue;
            }
            if (order instanceof OrderEraseUnprotectedToAddress) {
                this.processEUA((OrderEraseUnprotectedToAddress)order);
                continue;
            }
            if (order instanceof OrderNewLine) {
                this.processNewLine();
                continue;
            }
            if (order instanceof OrderFormFeed) {
                this.processFormFeed();
                continue;
            }
            if (order instanceof OrderCarrageReturn) {
                this.processCarrageReturn();
                continue;
            }
            if (order instanceof OrderEndOfMedium) {
                this.processEndOfMedium();
                continue;
            }
            if (order instanceof OrderGraphicsEscape) {
                this.processGraphicsEscape((OrderGraphicsEscape)order);
                continue;
            }
            throw new DatastreamException("Unsupported Order - " + order.getClass().getName());
        }
        if (writeControlCharacter.isKeyboardReset()) {
            this.lastAid = AttentionIdentification.NONE;
            this.unlockKeyboard();
            this.workingCursor = 0;
        }
        LinkedList<IScreenUpdateListener> linkedList = this.updateListeners;
        synchronized (linkedList) {
            for (IScreenUpdateListener listener : this.updateListeners) {
                listener.screenUpdated(IScreenUpdateListener.Direction.RECEIVED, null);
            }
        }
    }

    public synchronized void erase() {
        if (this.usingAlternate || this.buffer == null) {
            this.columns = this.primaryColumns;
            this.rows = this.primaryRows;
            this.allocateBuffer();
            this.usingAlternate = false;
        }
        for (int i = 0; i < this.buffer.length; ++i) {
            this.buffer[i] = null;
        }
        this.screenCursor = 0;
        this.workingCursor = 0;
    }

    public synchronized void eraseAlternate() {
        if (!this.hasAlternate) {
            this.erase();
            return;
        }
        if (!this.usingAlternate || this.buffer == null) {
            this.columns = this.alternateColumns;
            this.rows = this.alternateRows;
            this.allocateBuffer();
            this.usingAlternate = true;
        }
        for (int i = 0; i < this.buffer.length; ++i) {
            this.buffer[i] = null;
        }
        this.screenCursor = 0;
        this.workingCursor = 0;
    }

    private void allocateBuffer() {
        this.screenSize = this.columns * this.rows;
        this.buffer = new IBufferHolder[this.screenSize];
    }

    private synchronized void processSBA(OrderSetBufferAddress order) {
        this.workingCursor = order.getBufferAddress();
        if (this.workingCursor >= this.screenSize) {
            this.workingCursor -= this.screenSize;
        }
    }

    private synchronized void processRA(OrderRepeatToAddress order) throws DatastreamException {
        int endOfRepeat = order.getBufferAddress();
        if (endOfRepeat > this.screenSize || endOfRepeat < 0) {
            throw new DatastreamException("Impossible RA end address " + endOfRepeat + ", screen size is " + this.screenSize);
        }
        boolean firstPosition = true;
        while (firstPosition || this.workingCursor != endOfRepeat) {
            this.buffer[this.workingCursor] = new BufferChar(order.getChar());
            if (endOfRepeat == this.screenSize && this.workingCursor == this.screenSize - 1) {
                endOfRepeat = 0;
                break;
            }
            firstPosition = false;
            this.incrementWorkingCursor();
        }
        this.workingCursor = endOfRepeat;
    }

    private void incrementWorkingCursor() {
        ++this.workingCursor;
        if (this.workingCursor >= this.screenSize) {
            this.workingCursor = 0;
        }
    }

    private void processSF(OrderStartField order) {
        this.buffer[this.workingCursor] = new BufferStartOfField(this.workingCursor, order.isFieldProtected(), order.isFieldNumeric(), order.isFieldDisplay(), order.isFieldIntenseDisplay(), order.isFieldSelectorPen(), order.isFieldModifed());
        this.incrementWorkingCursor();
    }

    private void processSFE(OrderStartFieldExtended order) {
        List<IAttribute> attributes = order.getAttributes();
        BufferStartOfField bsf = null;
        for (IAttribute attr : attributes) {
            if (!(attr instanceof OrderStartField)) continue;
            OrderStartField sf = (OrderStartField)attr;
            bsf = new BufferStartOfField(this.workingCursor, sf.isFieldProtected(), sf.isFieldNumeric(), sf.isFieldDisplay(), sf.isFieldIntenseDisplay(), sf.isFieldSelectorPen(), sf.isFieldModifed());
        }
        if (bsf == null) {
            bsf = new BufferStartOfField(this.workingCursor, false, false, true, false, false, false);
        }
        this.buffer[this.workingCursor] = bsf;
        this.incrementWorkingCursor();
    }

    private void processEUA(OrderEraseUnprotectedToAddress order) {
        boolean charProtected = true;
        IBufferHolder bh = this.buffer[this.workingCursor];
        if (bh instanceof BufferStartOfField) {
            charProtected = ((BufferStartOfField)bh).isProtected();
        } else {
            int searchCursor = this.workingCursor - 1;
            if (searchCursor < 0) {
                searchCursor = this.screenSize - 1;
            }
            boolean found = false;
            while (searchCursor != this.workingCursor) {
                bh = this.buffer[searchCursor];
                if (bh instanceof BufferStartOfField) {
                    charProtected = ((BufferStartOfField)bh).isProtected();
                    found = true;
                    break;
                }
                if (--searchCursor >= 0) continue;
                searchCursor = this.screenSize - 1;
            }
            if (!found) {
                charProtected = false;
            }
        }
        int toAddress = order.getBufferAddress();
        if (toAddress >= this.screenSize) {
            toAddress = this.screenSize - 1;
        }
        if (toAddress < 0) {
            toAddress = 0;
        }
        int eraseCursor = this.workingCursor;
        do {
            if ((bh = this.buffer[eraseCursor]) instanceof BufferStartOfField) {
                charProtected = ((BufferStartOfField)bh).isProtected();
            } else if (!charProtected) {
                this.buffer[eraseCursor] = null;
            }
            if (++eraseCursor < this.screenSize) continue;
            eraseCursor = 0;
        } while (eraseCursor != toAddress);
    }

    private void processSA(OrderSetAttribute order) {
    }

    private void processNewLine() {
        this.buffer[this.workingCursor] = new BufferNewLine();
        this.incrementWorkingCursor();
    }

    private void processFormFeed() {
        this.buffer[this.workingCursor] = new BufferFormFeed();
        this.incrementWorkingCursor();
    }

    private void processCarrageReturn() {
        this.buffer[this.workingCursor] = new BufferCarrageReturn();
        this.incrementWorkingCursor();
    }

    private void processEndOfMedium() {
        this.buffer[this.workingCursor] = new BufferEndOfMedium();
        this.incrementWorkingCursor();
    }

    private void processGraphicsEscape(OrderGraphicsEscape order) {
        this.buffer[this.workingCursor] = new BufferGraphicsEscape(order.getByte());
        this.incrementWorkingCursor();
    }

    private void processText(OrderText order) {
        String text = order.getText();
        for (int i = 0; i < text.length(); ++i) {
            this.buffer[this.workingCursor] = new BufferChar(text.charAt(i));
            this.incrementWorkingCursor();
        }
    }

    public String printScreen() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.buffer.length; ++i) {
            if (this.buffer[i] == null) {
                sb.append(" ");
                continue;
            }
            sb.append(this.buffer[i].getStringWithoutNulls());
        }
        StringBuilder screenSB = new StringBuilder();
        String screenString = sb.toString();
        for (int i = 0; i < this.screenSize; i += this.columns) {
            screenSB.append(screenString.substring(i, i + this.columns));
            screenSB.append('\n');
        }
        return screenSB.toString();
    }

    public String printScreenTextWithCursor() {
        int cursorRow = this.screenCursor / this.columns;
        int cursorCol = this.screenCursor % this.columns;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.buffer.length; ++i) {
            if (this.buffer[i] == null) {
                sb.append(" ");
                continue;
            }
            sb.append(this.buffer[i].getStringWithoutNulls());
        }
        StringBuilder screenSB = new StringBuilder();
        String screenString = sb.toString();
        int row = 0;
        for (int i = 0; i < this.screenSize; i += this.columns) {
            screenSB.append("=|");
            screenSB.append(screenString.substring(i, i + this.columns));
            screenSB.append("|");
            screenSB.append('\n');
            if (row == cursorRow) {
                screenSB.append("^|");
                for (int j = 0; j < cursorCol; ++j) {
                    screenSB.append(" ");
                }
                screenSB.append("^");
                screenSB.append('\n');
            }
            ++row;
        }
        screenSB.append("!| ");
        screenSB.append(this.reportOperator());
        screenSB.append("\n");
        return screenSB.toString();
    }

    private String reportOperator() {
        int cursorRow = this.screenCursor / this.columns;
        int cursorCol = this.screenCursor % this.columns;
        StringBuilder operator = new StringBuilder();
        if (this.network.isConnected()) {
            operator.append("Connected-");
        } else {
            operator.append("Disconnected-");
        }
        if (this.network.isTls() || this.network.isSwitchedSSL()) {
            operator.append("SSL ");
        } else {
            operator.append("Plain");
        }
        operator.append(" Size=" + this.rows + "x" + this.columns);
        operator.append(" Cursor=" + this.screenCursor + "," + cursorRow + "x" + cursorCol);
        if (this.keyboardLockSet) {
            operator.append(" Keyboard Locked");
        } else {
            operator.append(" Keyboard Unlocked");
        }
        return operator.toString();
    }

    public String retrieveFlatScreen() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.buffer.length; ++i) {
            if (this.buffer[i] == null) {
                sb.append(" ");
                continue;
            }
            sb.append(this.buffer[i].getStringWithoutNulls());
        }
        return sb.toString();
    }

    @NotNull
    public synchronized Field[] calculateFields() {
        ArrayList<Field> fields = new ArrayList<Field>();
        Field currentField = null;
        if (!(this.buffer[0] instanceof BufferStartOfField)) {
            BufferStartOfField wrapSoField = null;
            for (int i = this.buffer.length - 1; i >= 0; --i) {
                IBufferHolder bh = this.buffer[i];
                if (!(bh instanceof BufferStartOfField)) continue;
                wrapSoField = (BufferStartOfField)bh;
                break;
            }
            currentField = wrapSoField == null ? new Field() : new Field(-1, wrapSoField);
        }
        for (int i = 0; i < this.buffer.length; ++i) {
            IBufferHolder bh = this.buffer[i];
            if (bh == null) {
                currentField.appendChar('\u0000');
                continue;
            }
            if (bh instanceof BufferStartOfField) {
                if (currentField != null) {
                    fields.add(currentField);
                }
                currentField = new Field(i, (BufferStartOfField)bh);
                continue;
            }
            if (bh instanceof BufferChar) {
                currentField.appendChar(((BufferChar)bh).getChar());
                continue;
            }
            throw new UnsupportedOperationException("Unrecognised buffer type " + bh.getClass().getName());
        }
        if (currentField != null) {
            fields.add(currentField);
        }
        if (fields.size() >= 2 && ((Field)fields.get(0)).getStart() == 0 && ((Field)fields.get(1)).getStart() == 0) {
            fields.remove(0);
        }
        return fields.toArray(new Field[fields.size()]);
    }

    public void searchFieldContaining(String text) throws TextNotFoundException {
        for (Field field : this.calculateFields()) {
            if (!field.containsText(text)) continue;
            return;
        }
        throw new TextNotFoundException(CANT_FIND_TEXT + text + "'");
    }

    public int searchFieldContaining(@NotNull String[] okText, String[] errorText) throws TextNotFoundException, ErrorTextFoundException {
        int i;
        if (errorText != null) {
            for (i = 0; i < errorText.length; ++i) {
                for (Field field : this.calculateFields()) {
                    if (!field.containsText(errorText[i])) continue;
                    throw new ErrorTextFoundException("Found error text '" + errorText[i] + "' on screen", i);
                }
            }
        }
        for (i = 0; i < okText.length; ++i) {
            for (Field field : this.calculateFields()) {
                if (!field.containsText(okText[i])) continue;
                return i;
            }
        }
        throw new TextNotFoundException("Unable to locate text on sreen");
    }

    public boolean isTextInField(String text) {
        for (Field field : this.calculateFields()) {
            if (!field.containsText(text)) continue;
            return true;
        }
        return false;
    }

    public void waitForKeyboard(int maxWait) throws TimeoutException, TerminalInterruptedException {
        try {
            if (!this.keyboardLock.tryAcquire(maxWait, TimeUnit.MILLISECONDS)) {
                throw new TimeoutException("Wait for keyboard took longer than " + maxWait + "ms");
            }
        }
        catch (InterruptedException e) {
            throw new TerminalInterruptedException("Wait for keyboard was interrupted", e);
        }
        this.keyboardLock.release();
    }

    public int waitForTextInField(String text, long maxWait) throws TerminalInterruptedException, TextNotFoundException, Zos3270Exception {
        return this.waitForTextInField(new String[]{text}, null, maxWait);
    }

    public int waitForTextInField(String[] ok, String[] error, long timeoutInMilliseconds) throws TerminalInterruptedException, TextNotFoundException, ErrorTextFoundException, Zos3270Exception {
        int foundIndex = -1;
        try {
            foundIndex = ScreenUpdateTextListener.waitForText(this, ok, error, timeoutInMilliseconds);
            if (foundIndex < 0) {
                if (ok != null && ok.length == 1 && error == null) {
                    throw new TextNotFoundException(CANT_FIND_TEXT + ok[0] + "'");
                }
                throw new TextNotFoundException("Unable to find a field containing any of the request text");
            }
        }
        catch (InterruptedException e) {
            throw new TerminalInterruptedException("Wait for text was interrupted", e);
        }
        return foundIndex;
    }

    public synchronized void positionCursorToFieldContaining(@NotNull String text) throws KeyboardLockedException, TextNotFoundException {
        if (this.keyboardLockSet) {
            throw new KeyboardLockedException("Unable to move cursor as keyboard is locked");
        }
        for (Field field : this.calculateFields()) {
            if (!field.containsText(text)) continue;
            this.screenCursor = field.getStart();
            return;
        }
        throw new TextNotFoundException(CANT_FIND_TEXT + text + "'");
    }

    public synchronized void eraseEof() throws KeyboardLockedException, FieldNotFoundException {
        if (this.keyboardLockSet) {
            throw new KeyboardLockedException("Unable to move cursor as keyboard is locked");
        }
        if (this.buffer[this.screenCursor] != null && !(this.buffer[this.screenCursor] instanceof BufferChar)) {
            throw new FieldNotFoundException("Unable to type where the cursor is pointing to - " + this.screenCursor);
        }
        BufferStartOfField sf = null;
        int sfPos = this.screenCursor - 1;
        if (sfPos < 0) {
            sfPos = this.buffer.length - 1;
        }
        while (sfPos != this.screenCursor) {
            if (this.buffer[sfPos] instanceof BufferStartOfField) {
                sf = (BufferStartOfField)this.buffer[sfPos];
                break;
            }
            if (--sfPos >= 0) continue;
            sfPos = this.buffer.length - 1;
        }
        if (sf != null && sf.isProtected()) {
            throw new FieldNotFoundException("Unable to type where the cursor is pointing to - " + this.screenCursor);
        }
        int pos = this.screenCursor;
        while (this.buffer[pos] instanceof BufferChar) {
            this.buffer[pos] = new BufferChar('\u0000');
            if (++pos >= this.screenSize) {
                pos = 0;
            }
            if (pos != this.screenCursor) continue;
        }
        if (sf != null) {
            sf.setFieldModified();
        }
    }

    public synchronized void eraseInput() throws KeyboardLockedException, FieldNotFoundException {
        if (this.keyboardLockSet) {
            throw new KeyboardLockedException("Unable to erase input as keyboard is locked");
        }
        boolean unprotected = false;
        BufferStartOfField startOfFieldUnprotected = null;
        if (!(this.buffer[0] instanceof BufferStartOfField)) {
            BufferStartOfField wrapSoField = null;
            for (int i = this.buffer.length - 1; i >= 0; --i) {
                IBufferHolder bh = this.buffer[i];
                if (!(bh instanceof BufferStartOfField)) continue;
                wrapSoField = (BufferStartOfField)bh;
                break;
            }
            if (wrapSoField == null) {
                unprotected = true;
            } else {
                unprotected = !wrapSoField.isProtected();
                startOfFieldUnprotected = wrapSoField;
            }
        }
        for (int i = 0; i < this.screenSize; ++i) {
            IBufferHolder bh = this.buffer[i];
            if (bh instanceof BufferStartOfField) {
                BufferStartOfField sof = (BufferStartOfField)bh;
                boolean bl = unprotected = !sof.isProtected();
                if (unprotected) {
                    startOfFieldUnprotected = sof;
                    continue;
                }
                startOfFieldUnprotected = null;
                continue;
            }
            if (!unprotected) continue;
            this.buffer[i] = null;
            if (startOfFieldUnprotected == null) continue;
            startOfFieldUnprotected.setFieldModified();
        }
    }

    public synchronized void tab() throws KeyboardLockedException, FieldNotFoundException {
        if (this.keyboardLockSet) {
            throw new KeyboardLockedException("Unable to move cursor as keyboard is locked");
        }
        int startPosition = this.screenCursor;
        boolean foundUnprotectedField = false;
        IBufferHolder sfCheck = this.buffer[this.screenCursor];
        if (sfCheck instanceof BufferStartOfField) {
            foundUnprotectedField = !((BufferStartOfField)sfCheck).isProtected();
        }
        do {
            IBufferHolder previousBuffer;
            ++this.screenCursor;
            if (this.screenCursor >= this.screenSize) {
                this.screenCursor = 0;
            }
            if ((previousBuffer = this.buffer[this.screenCursor]) == null || previousBuffer instanceof BufferChar) {
                if (!foundUnprotectedField) continue;
                return;
            }
            if (previousBuffer instanceof BufferStartOfField) {
                BufferStartOfField sof = (BufferStartOfField)previousBuffer;
                foundUnprotectedField = !sof.isProtected();
                continue;
            }
            throw new FieldNotFoundException("Unrecognised buffer type at pos " + this.screenCursor);
        } while (this.screenCursor != startPosition);
        this.screenCursor = 0;
    }

    public synchronized void backTab() throws KeyboardLockedException, FieldNotFoundException {
        if (this.keyboardLockSet) {
            throw new KeyboardLockedException("Unable to move cursor as keyboard is locked");
        }
        int startPosition = this.screenCursor;
        int lastCharField = -1;
        boolean foundUnprotectedField = false;
        do {
            IBufferHolder previousBuffer;
            int previousPositionInBuffer;
            if ((previousPositionInBuffer = this.screenCursor - 1) < 0) {
                previousPositionInBuffer = this.screenSize - 1;
            }
            if ((previousBuffer = this.buffer[previousPositionInBuffer]) == null || previousBuffer instanceof BufferChar) {
                lastCharField = previousPositionInBuffer;
            } else if (previousBuffer instanceof BufferStartOfField) {
                BufferStartOfField sof = (BufferStartOfField)previousBuffer;
                if (sof.isProtected()) {
                    lastCharField = -1;
                } else {
                    foundUnprotectedField = true;
                    if (lastCharField != -1) {
                        this.screenCursor = lastCharField;
                        return;
                    }
                }
            } else {
                throw new FieldNotFoundException("Unrecognised buffer type at pos " + previousPositionInBuffer);
            }
            this.screenCursor = previousPositionInBuffer;
        } while (this.screenCursor != startPosition);
        if (!foundUnprotectedField) {
            this.screenCursor = 0;
        }
    }

    public synchronized void cursorUp() throws KeyboardLockedException {
        if (this.keyboardLockSet) {
            throw new KeyboardLockedException("Unable to move cursor as keyboard is locked");
        }
        this.screenCursor -= this.columns;
        if (this.screenCursor < 0) {
            this.screenCursor = this.screenSize + this.screenCursor;
        }
    }

    public synchronized void cursorDown() throws KeyboardLockedException {
        if (this.keyboardLockSet) {
            throw new KeyboardLockedException("Unable to move cursor as keyboard is locked");
        }
        this.screenCursor += this.columns;
        if (this.screenCursor >= this.screenSize) {
            this.screenCursor -= this.screenSize;
        }
    }

    public synchronized void cursorLeft() throws KeyboardLockedException {
        if (this.keyboardLockSet) {
            throw new KeyboardLockedException("Unable to move cursor as keyboard is locked");
        }
        --this.screenCursor;
        if (this.screenCursor < 0) {
            this.screenCursor = this.screenSize - this.screenCursor;
        }
    }

    public synchronized void cursorRight() throws KeyboardLockedException {
        if (this.keyboardLockSet) {
            throw new KeyboardLockedException("Unable to move cursor as keyboard is locked");
        }
        ++this.screenCursor;
        if (this.screenCursor >= this.screenSize) {
            this.screenCursor -= this.screenSize;
        }
    }

    public synchronized void home() throws KeyboardLockedException {
        if (this.keyboardLockSet) {
            throw new KeyboardLockedException("Unable to move cursor as keyboard is locked");
        }
        Field[] fields = this.calculateFields();
        if (fields == null || fields.length == 0) {
            this.screenCursor = 0;
            return;
        }
        for (Field field : fields) {
            if (field.isProtected() || field.length() <= 1) continue;
            this.screenCursor = field.isDummyField() ? 0 : field.getStart() + 1;
            return;
        }
        this.screenCursor = 0;
    }

    public synchronized void newLine() throws KeyboardLockedException {
        Field nextField;
        int fieldPos;
        if (this.keyboardLockSet) {
            throw new KeyboardLockedException("Unable to move cursor as keyboard is locked");
        }
        Field[] fields = this.calculateFields();
        int newCursor = (this.screenCursor / this.columns + 1) * this.columns;
        if (newCursor >= this.screenSize) {
            newCursor = 0;
        }
        if (fields == null || fields.length == 0) {
            this.screenCursor = newCursor;
            return;
        }
        Field startField = null;
        for (fieldPos = 0; fieldPos < fields.length; ++fieldPos) {
            if (!fields[fieldPos].containsPosition(newCursor)) continue;
            startField = fields[fieldPos];
            break;
        }
        if (!startField.isProtected() && startField.length() > 1) {
            if (newCursor == startField.getStart() && !startField.isDummyField()) {
                ++newCursor;
            }
            this.screenCursor = newCursor;
            return;
        }
        do {
            if (++fieldPos >= fields.length) {
                fieldPos = 0;
            }
            if ((nextField = fields[fieldPos]).isProtected() || nextField.length() <= 1) continue;
            this.screenCursor = nextField.isDummyField() ? nextField.getStart() : nextField.getStart() + 1;
            return;
        } while (nextField != startField);
        this.screenCursor = newCursor;
    }

    public void backSpace() throws KeyboardLockedException, FieldNotFoundException {
        if (this.keyboardLockSet) {
            throw new KeyboardLockedException("Unable to type as keyboard is locked");
        }
        int position = this.screenCursor;
        if (this.buffer[position] != null && !(this.buffer[position] instanceof BufferChar)) {
            throw new FieldNotFoundException("Unable to type where the cursor is pointing to - " + this.screenCursor);
        }
        BufferStartOfField sf = null;
        int sfPos = position - 1;
        if (sfPos < 0) {
            sfPos = this.buffer.length - 1;
        }
        while (sfPos != position) {
            if (this.buffer[sfPos] instanceof BufferStartOfField) {
                sf = (BufferStartOfField)this.buffer[sfPos];
                break;
            }
            if (--sfPos >= 0) continue;
            sfPos = this.buffer.length - 1;
        }
        if (sf != null && sf.isProtected()) {
            throw new FieldNotFoundException("Unable to type where the cursor is pointing to - " + position);
        }
        if (position == 0) {
            return;
        }
        if (sfPos == position - 1) {
            throw new FieldNotFoundException("Unable to backspace where the cursor is pointing to - " + position + ", start of field");
        }
        do {
            this.buffer[position - 1] = this.buffer[position];
            this.buffer[position] = null;
        } while (++position < this.screenSize && (this.buffer[position] == null || this.buffer[position] instanceof BufferChar));
        --this.screenCursor;
    }

    public int getNoOfColumns() {
        return this.columns;
    }

    public int getNoOfRows() {
        return this.rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void registerScreenUpdateListener(IScreenUpdateListener listener) {
        LinkedList<IScreenUpdateListener> linkedList = this.updateListeners;
        synchronized (linkedList) {
            this.updateListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unregisterScreenUpdateListener(IScreenUpdateListener listener) {
        LinkedList<IScreenUpdateListener> linkedList = this.updateListeners;
        synchronized (linkedList) {
            this.updateListeners.remove(listener);
        }
    }

    public int getCursor() {
        return this.screenCursor;
    }

    public Field locateFieldAt(int cursorPos) {
        Field[] fields = this.calculateFields();
        for (int fieldPosition = 0; fieldPosition < fields.length; ++fieldPosition) {
            Field field = fields[fieldPosition];
            if (!field.containsPosition(cursorPos)) continue;
            return field;
        }
        return null;
    }

    public String getValueFromFieldContaining(String text) throws TextNotFoundException {
        Boolean foundHeader = false;
        for (Field field : this.calculateFields()) {
            if (!foundHeader.booleanValue()) {
                if (!field.containsText(text)) continue;
                foundHeader = true;
                continue;
            }
            String foundText = field.getFieldWithoutNulls();
            if (foundText.length() <= 0) continue;
            return foundText;
        }
        throw new TextNotFoundException(CANT_FIND_TEXT + text + "'");
    }

    public synchronized void type(String text) throws KeyboardLockedException, FieldNotFoundException {
        this.screenCursor = this.type(text, this.screenCursor);
    }

    public synchronized int type(String text, int column, int row) throws KeyboardLockedException, FieldNotFoundException {
        int position = column + row * this.columns;
        return this.type(text, position);
    }

    public synchronized int type(String text, int position) throws KeyboardLockedException, FieldNotFoundException {
        if (this.keyboardLockSet) {
            throw new KeyboardLockedException("Unable to type as keyboard is locked");
        }
        if (this.buffer[position] != null && !(this.buffer[position] instanceof BufferChar)) {
            throw new FieldNotFoundException("Unable to type where the cursor is pointing to - " + position);
        }
        BufferStartOfField sf = null;
        int sfPos = position - 1;
        if (sfPos < 0) {
            sfPos = this.buffer.length - 1;
        }
        while (sfPos != position) {
            if (this.buffer[sfPos] instanceof BufferStartOfField) {
                sf = (BufferStartOfField)this.buffer[sfPos];
                break;
            }
            if (--sfPos >= 0) continue;
            sfPos = this.buffer.length - 1;
        }
        if (sf != null && sf.isProtected()) {
            throw new FieldNotFoundException("Unable to type where the cursor is pointing to - " + position);
        }
        if (text.length() == 0) {
            return position;
        }
        block1: for (int i = 0; i < text.length(); ++i) {
            IBufferHolder bh = this.buffer[position];
            if (bh != null && !(bh instanceof BufferChar)) {
                throw new FieldNotFoundException("Unable to type where the cursor is pointing to - " + position);
            }
            this.buffer[position] = new BufferChar(text.charAt(i));
            if (sf != null) {
                sf.setFieldModified();
            }
            boolean unprotected = true;
            while (true) {
                BufferStartOfField sof;
                if (++position >= this.screenSize) {
                    position = 0;
                }
                this.screenCursor = position;
                bh = this.buffer[position];
                if (unprotected && (bh == null || bh instanceof BufferChar)) continue block1;
                if (bh == null || !(bh instanceof BufferStartOfField) || !(unprotected = !(sof = (BufferStartOfField)bh).isProtected())) continue;
                sf = sof;
            }
        }
        return position;
    }

    public synchronized byte[] aid(AttentionIdentification aid) throws DatastreamException, TerminalInterruptedException {
        this.lockKeyboard();
        try {
            ByteArrayOutputStream outboundBuffer = new ByteArrayOutputStream();
            outboundBuffer.write(aid.getKeyValue());
            if (aid == AttentionIdentification.CLEAR) {
                this.erase();
            } else if (aid != AttentionIdentification.PA1 && aid != AttentionIdentification.PA2 && aid != AttentionIdentification.PA3) {
                BufferAddress cursor = new BufferAddress(this.screenCursor);
                outboundBuffer.write(cursor.getCharRepresentation());
                this.readModifiedBuffer(outboundBuffer);
            }
            this.writeTrace(outboundBuffer);
            for (IScreenUpdateListener listener : this.updateListeners) {
                listener.screenUpdated(IScreenUpdateListener.Direction.SENDING, aid);
            }
            this.lastAid = aid;
            return outboundBuffer.toByteArray();
        }
        catch (IOException e) {
            throw new DatastreamException("Unable to generate outbound datastream", e);
        }
    }

    public int getScreenSize() {
        return this.screenSize;
    }

    public String printFields() {
        Field[] fields = this.calculateFields();
        StringBuilder sb = new StringBuilder();
        for (Field field : fields) {
            sb.append(field.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public void setBuffer(IBufferHolder[] newBuffer) {
        for (int i = 0; i < this.buffer.length && i < newBuffer.length; ++i) {
            this.buffer[i] = newBuffer[i];
        }
    }

    public void setBuffer(int col, int row, String text) {
        int pos = row * this.columns + col;
        for (int i = 0; i < text.length(); ++i) {
            this.buffer[pos] = new BufferChar(text.charAt(i));
            ++pos;
        }
    }

    public void nullify(int col, int row, int len) {
        int pos = row * this.columns + col;
        for (int i = 0; i < len; ++i) {
            this.buffer[pos] = null;
            ++pos;
        }
    }

    public Field getFieldAt(int col, int row) {
        int pos = row * this.columns + col;
        Field[] fields = this.calculateFields();
        Field currentField = fields[0];
        for (int i = 1; i < fields.length; ++i) {
            if (fields[i].getStart() > pos) {
                return currentField;
            }
            currentField = fields[i];
        }
        return currentField;
    }

    public void setCursorPosition(int newPosition) {
        this.screenCursor = newPosition;
    }

    public void setCursorPosition(int column, int row) {
        this.screenCursor = row * this.columns + column;
    }

    public synchronized void registerDatastreamListener(IDatastreamListener listener) {
        if (listener == null) {
            return;
        }
        if (!this.datastreamListeners.contains(listener)) {
            this.datastreamListeners.add(listener);
        }
    }

    public synchronized void unregisterDatastreamListener(IDatastreamListener listener) {
        this.datastreamListeners.remove(listener);
    }

    public List<IDatastreamListener> getDatastreamListeners() {
        return this.datastreamListeners;
    }

    public int getPrimaryColumns() {
        return this.primaryColumns;
    }

    public int getPrimaryRows() {
        return this.primaryRows;
    }

    public int getAlternateColumns() {
        return this.alternateColumns;
    }

    public int getAlternateRows() {
        return this.alternateRows;
    }

    public void testingSetLastAid(AttentionIdentification aid) {
        this.lastAid = aid;
    }

    public synchronized boolean isClearScreen() {
        for (IBufferHolder bh : this.buffer) {
            if (bh == null) continue;
            return false;
        }
        return true;
    }
}

