/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zos3270.spi;

import dev.galasa.zos3270.spi.BufferStartOfField;
import java.nio.charset.Charset;
import java.util.Arrays;

public class Field {
    private static final Charset ebcdic = Charset.forName("Cp037");
    private final int start;
    private char[] text;
    private final boolean fieldProtected;
    private final boolean fieldNumeric;
    private final boolean fieldDisplay;
    private final boolean fieldIntenseDisplay;
    private final boolean fieldSelectorPen;
    private final boolean fieldModifed;

    protected Field(int start, BufferStartOfField sf) {
        this.start = start;
        this.fieldProtected = sf.isProtected();
        this.fieldNumeric = sf.isNumeric();
        this.fieldDisplay = sf.isDisplay();
        this.fieldIntenseDisplay = sf.isIntenseDisplay();
        this.fieldSelectorPen = sf.isSelectorPen();
        this.fieldModifed = sf.isFieldModifed();
        this.text = new char[0];
    }

    public Field() {
        this.start = -1;
        this.fieldProtected = false;
        this.fieldNumeric = false;
        this.fieldDisplay = true;
        this.fieldIntenseDisplay = false;
        this.fieldSelectorPen = false;
        this.fieldModifed = false;
        this.text = new char[0];
    }

    protected void appendChar(char newChar) {
        char[] newText = Arrays.copyOf(this.text, this.text.length + 1);
        newText[newText.length - 1] = newChar;
        this.text = newText;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Field(pos=");
        sb.append(Integer.toString(this.start));
        sb.append(",p=");
        sb.append(Boolean.toString(this.fieldProtected));
        sb.append(",n=");
        sb.append(Boolean.toString(this.fieldNumeric));
        sb.append(",d=");
        sb.append(Boolean.toString(this.fieldDisplay));
        sb.append(",i=");
        sb.append(Boolean.toString(this.fieldIntenseDisplay));
        sb.append(",s=");
        sb.append(Boolean.toString(this.fieldSelectorPen));
        sb.append(",m=");
        sb.append(Boolean.toString(this.fieldModifed));
        sb.append(",");
        sb.append(this.getFieldWithoutNulls());
        sb.append(")");
        return sb.toString();
    }

    public int length() {
        return this.text.length + 1;
    }

    public boolean containsText(String searchText) {
        return new String(this.text).contains(searchText);
    }

    public int getStart() {
        if (this.start == -1) {
            return 0;
        }
        return this.start;
    }

    public boolean containsPosition(int screenCursor) {
        int end = this.start + this.text.length;
        return this.start <= screenCursor && screenCursor <= end;
    }

    public boolean isProtected() {
        return this.fieldProtected;
    }

    public boolean isNumeric() {
        return this.fieldNumeric;
    }

    public boolean isDisplay() {
        return this.fieldDisplay;
    }

    public boolean isIntenseDisplay() {
        return this.fieldIntenseDisplay;
    }

    public boolean isSelectorPen() {
        return this.fieldSelectorPen;
    }

    public boolean isFieldModifed() {
        return this.fieldModifed;
    }

    public boolean isUnformatted() {
        return this.start == -1;
    }

    public String getFieldWithoutNulls() {
        StringBuilder sb = new StringBuilder();
        for (char c : this.text) {
            if (c == '\u0000') {
                sb.append(" ");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public byte[] getFieldWithNulls() {
        String otext = new String(this.text);
        return otext.getBytes(ebcdic);
    }

    public Character[] getFieldCharsWithNulls() {
        Character[] newChars = new Character[this.text.length];
        for (int i = 0; i < this.text.length; ++i) {
            newChars[i] = this.text[i] == '\u0000' ? null : Character.valueOf(this.text[i]);
        }
        return newChars;
    }

    public boolean isDummyField() {
        return this.start == -1;
    }
}

