/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zos3270.spi;

import dev.galasa.zos3270.spi.IBufferHolder;
import java.nio.charset.Charset;

public class BufferChar
implements IBufferHolder {
    private static final Charset ebcdic = Charset.forName("Cp037");
    private final char character;

    public BufferChar(char character) {
        if (character == '\uffffffff') {
            character = (char)32;
        }
        this.character = character;
    }

    public String toString() {
        return "char(" + this.character + ")";
    }

    @Override
    public String getStringWithoutNulls() {
        if (this.character == '\u0000') {
            return " ";
        }
        return "" + this.character;
    }

    @Override
    public char getChar() {
        return this.character;
    }

    public byte getFieldEbcdic() {
        if (this.character == '\u0000') {
            return 0;
        }
        String value = new String(new char[]{this.character});
        return value.getBytes(ebcdic)[0];
    }
}

