/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zos3270.internal.terminal;

import dev.galasa.zos3270.AttentionIdentification;
import dev.galasa.zos3270.ErrorTextFoundException;
import dev.galasa.zos3270.IScreenUpdateListener;
import dev.galasa.zos3270.TextNotFoundException;
import dev.galasa.zos3270.Zos3270Exception;
import dev.galasa.zos3270.spi.Screen;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class ScreenUpdateTextListener
implements IScreenUpdateListener {
    private final Screen screen;
    private final String[] okText;
    private final String[] errorText;
    private int foundItem = -1;
    private ErrorTextFoundException errorFound = null;
    private Semaphore textFound = new Semaphore(1, true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScreenUpdateTextListener(Screen screen, String[] ok, String[] error) throws InterruptedException {
        this.screen = screen;
        this.okText = ok;
        this.errorText = error;
        this.textFound.acquire();
        Screen screen2 = this.screen;
        synchronized (screen2) {
            this.screenUpdated(IScreenUpdateListener.Direction.RECEIVED, null);
            if (this.textFound.availablePermits() > 0) {
                return;
            }
            this.screen.registerScreenUpdateListener(this);
        }
    }

    @Override
    public void screenUpdated(IScreenUpdateListener.Direction direction, AttentionIdentification aid) {
        try {
            this.foundItem = this.screen.searchFieldContaining(this.okText, this.errorText);
            this.textFound.release();
        }
        catch (TextNotFoundException textNotFoundException) {
        }
        catch (ErrorTextFoundException e) {
            this.errorFound = e;
            this.textFound.release();
        }
    }

    public int waitForText(long maxWait) throws InterruptedException, ErrorTextFoundException, Zos3270Exception {
        if (this.textFound == null) {
            throw new Zos3270Exception("Not allowed to use this listener more than once");
        }
        this.textFound.tryAcquire(1, maxWait, TimeUnit.MILLISECONDS);
        this.textFound = null;
        this.screen.unregisterScreenUpdateListener(this);
        if (this.errorFound != null) {
            throw this.errorFound;
        }
        return this.foundItem;
    }

    public static int waitForText(Screen screen, String[] ok, String[] error, long maxWait) throws InterruptedException, Zos3270Exception {
        return new ScreenUpdateTextListener(screen, ok, error).waitForText(maxWait);
    }
}

