/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zos3270.internal.properties;

import dev.galasa.framework.spi.IConfigurationPropertyStoreService;
import dev.galasa.zos3270.Zos3270ManagerException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={Zos3270PropertiesSingleton.class}, immediate=true)
public class Zos3270PropertiesSingleton {
    private static Zos3270PropertiesSingleton instance;
    private IConfigurationPropertyStoreService cps;

    @Activate
    public void activate() {
        Zos3270PropertiesSingleton.setInstance(this);
    }

    @Deactivate
    public void deacivate() {
        Zos3270PropertiesSingleton.setInstance(null);
    }

    public static IConfigurationPropertyStoreService cps() throws Zos3270ManagerException {
        if (instance != null) {
            return Zos3270PropertiesSingleton.instance.cps;
        }
        throw new Zos3270ManagerException("Attempt to access manager CPS before it has been initialised");
    }

    public static void setCps(IConfigurationPropertyStoreService cps) throws Zos3270ManagerException {
        if (instance != null) {
            Zos3270PropertiesSingleton.instance.cps = cps;
            return;
        }
        throw new Zos3270ManagerException("Attempt to set manager CPS before instance created");
    }

    private static synchronized void setInstance(Zos3270PropertiesSingleton newInstance) {
        instance = newInstance;
    }
}

