/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zos3270.internal.datastream;

import java.util.BitSet;

public class WriteControlCharacter {
    private boolean nop;
    private boolean reset;
    private boolean printer1;
    private boolean printer2;
    private boolean startPrinter;
    private boolean soundAlarm;
    private boolean keyboardReset;
    private boolean resetMDT;

    public WriteControlCharacter() {
    }

    public WriteControlCharacter(byte wcc) {
        BitSet bitSet = BitSet.valueOf(new byte[]{wcc});
        this.nop = bitSet.get(7);
        this.reset = bitSet.get(6);
        this.printer1 = bitSet.get(5);
        this.printer2 = bitSet.get(4);
        this.startPrinter = bitSet.get(3);
        this.soundAlarm = bitSet.get(2);
        this.keyboardReset = bitSet.get(1);
        this.resetMDT = bitSet.get(0);
    }

    public WriteControlCharacter(boolean nop, boolean reset, boolean printer1, boolean printer2, boolean startPrinter, boolean soundAlarm, boolean keyboardReset, boolean resetMDT) {
        this.nop = nop;
        this.reset = reset;
        this.printer1 = printer1;
        this.printer2 = printer2;
        this.startPrinter = startPrinter;
        this.soundAlarm = soundAlarm;
        this.keyboardReset = keyboardReset;
        this.resetMDT = resetMDT;
    }

    public boolean isNop() {
        return this.nop;
    }

    public boolean isReset() {
        return this.reset;
    }

    public boolean isPrinter1() {
        return this.printer1;
    }

    public boolean isPrinter2() {
        return this.printer2;
    }

    public boolean isStartPrinter() {
        return this.startPrinter;
    }

    public boolean isSoundAlarm() {
        return this.soundAlarm;
    }

    public boolean isKeyboardReset() {
        return this.keyboardReset;
    }

    public boolean isResetMDT() {
        return this.resetMDT;
    }

    public byte[] getBytes() {
        BitSet bitSet = new BitSet(8);
        bitSet.set(7, this.nop);
        bitSet.set(6, this.reset);
        bitSet.set(5, this.printer1);
        bitSet.set(4, this.printer2);
        bitSet.set(3, this.startPrinter);
        bitSet.set(2, this.soundAlarm);
        bitSet.set(1, this.keyboardReset);
        bitSet.set(0, this.resetMDT);
        return bitSet.toByteArray();
    }
}

