/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zos3270.internal.datastream;

import dev.galasa.zos3270.internal.datastream.StructuredField;
import dev.galasa.zos3270.spi.NetworkException;
import java.util.Set;
import java.util.TreeSet;

public class StructuredFieldReadPartition
extends StructuredField {
    public static final byte QUERY = 2;
    public static final byte QUERY_LIST = 3;
    public static final byte REQTYP_LIST = 0;
    public static final byte REQTYP_EQUIVALENT = 64;
    public static final byte REQTYP_ALL = -128;
    private final int pid;
    private final Type type;
    private final Byte reqtyp;
    private final Set<Byte> qcodes = new TreeSet<Byte>();

    public StructuredFieldReadPartition(byte[] structuredFieldData) throws NetworkException {
        this.pid = structuredFieldData[1];
        switch (structuredFieldData[2]) {
            case 2: {
                this.type = Type.QUERY;
                this.reqtyp = null;
                break;
            }
            case 3: {
                this.type = Type.QUERY_LIST;
                this.reqtyp = structuredFieldData[3];
                if (this.reqtyp != 0 && this.reqtyp != 64 && this.reqtyp != -128) {
                    throw new NetworkException("Unsupported Read Partition Request Type code = " + this.reqtyp);
                }
                for (int i = 4; i < structuredFieldData.length; ++i) {
                    this.qcodes.add(structuredFieldData[i]);
                }
                break;
            }
            default: {
                throw new NetworkException("Unsupported Read Partition Type code = " + structuredFieldData[2]);
            }
        }
    }

    public int getPartitionId() {
        return this.pid;
    }

    public Type getType() {
        return this.type;
    }

    public Byte getRequestType() {
        return this.reqtyp;
    }

    public Set<Byte> getQcodes() {
        return this.qcodes;
    }

    public static enum Type {
        QUERY,
        QUERY_LIST;

    }
}

