/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zos3270.internal.datastream;

import dev.galasa.zos3270.internal.datastream.AbstractQueryReply;
import dev.galasa.zos3270.spi.Screen;
import java.nio.ByteBuffer;

public class QueryReplyUsableArea
extends AbstractQueryReply {
    private static final byte USUABLE_AREA = -127;
    private final int cellX;
    private final int cellY;
    private final int maxBuffer;
    private static final byte UNITS = 1;
    private static final byte[] XR = new byte[]{0, 10, 2, -27};
    private static final byte[] YR = new byte[]{0, 2, 0, 111};
    private static final byte AW = 9;
    private static final byte AH = 12;

    public QueryReplyUsableArea(Screen screen) {
        this.cellX = screen.getNoOfColumns();
        this.cellY = screen.getNoOfRows();
        int primaryBuffer = screen.getPrimaryColumns() * screen.getPrimaryRows();
        int alternateBuffer = screen.getAlternateColumns() * screen.getAlternateRows();
        this.maxBuffer = primaryBuffer >= alternateBuffer ? primaryBuffer : alternateBuffer;
    }

    @Override
    public byte[] toByte() {
        ByteBuffer buffer = ByteBuffer.allocate(23);
        buffer.putShort((short)23);
        buffer.put((byte)-127);
        buffer.put((byte)-127);
        buffer.put((byte)1);
        buffer.put((byte)0);
        buffer.putShort((short)this.cellX);
        buffer.putShort((short)this.cellY);
        buffer.put((byte)1);
        buffer.put(XR);
        buffer.put(YR);
        buffer.put((byte)9);
        buffer.put((byte)12);
        buffer.putShort((short)this.maxBuffer);
        return buffer.array();
    }

    @Override
    public byte getID() {
        return -127;
    }
}

