/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zos3270.internal.datastream;

import dev.galasa.zos3270.internal.datastream.AbstractQueryReply;
import dev.galasa.zos3270.spi.Screen;
import java.nio.ByteBuffer;

public class QueryReplyImplicitPartition
extends AbstractQueryReply {
    private static final byte IMPLICIT_PARTITION = -90;
    private final int primaryX;
    private final int primaryY;
    private final int alternateX;
    private final int alternateY;

    public QueryReplyImplicitPartition(Screen screen) {
        this.primaryX = screen.getNoOfColumns();
        this.primaryY = screen.getNoOfRows();
        int aX = screen.getAlternateColumns();
        int aY = screen.getAlternateRows();
        if (aX < 1 || aY < 1) {
            this.alternateX = this.primaryX;
            this.alternateY = this.primaryY;
        } else {
            this.alternateX = aX;
            this.alternateY = aY;
        }
    }

    @Override
    public byte[] toByte() {
        ByteBuffer buffer = ByteBuffer.allocate(17);
        buffer.putShort((short)17);
        buffer.put((byte)-127);
        buffer.put((byte)-90);
        buffer.putShort((short)0);
        buffer.put((byte)11);
        buffer.put((byte)1);
        buffer.put((byte)0);
        buffer.putShort((short)this.primaryX);
        buffer.putShort((short)this.primaryY);
        buffer.putShort((short)this.alternateX);
        buffer.putShort((short)this.alternateY);
        return buffer.array();
    }

    @Override
    public byte getID() {
        return -90;
    }
}

