/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zos3270.internal.datastream;

import dev.galasa.zos3270.internal.datastream.AbstractOrder;
import dev.galasa.zos3270.internal.datastream.BufferAddress;
import dev.galasa.zos3270.internal.datastream.IAttribute;
import java.nio.ByteBuffer;
import java.util.BitSet;

public class OrderStartField
extends AbstractOrder
implements IAttribute {
    public static final byte ID = 29;
    public static final byte ATTRIBUTE_ID = -64;
    private final boolean fieldProtected;
    private final boolean fieldNumeric;
    private final boolean fieldDisplay;
    private final boolean fieldIntenseDisplay;
    private final boolean fieldSelectorPen;
    private final boolean fieldModifed;

    public OrderStartField(ByteBuffer buffer) {
        byte attributes = buffer.get();
        this.fieldProtected = (attributes & 0x20) == 32;
        this.fieldNumeric = (attributes & 0x10) == 16;
        this.fieldDisplay = (attributes & 8) == 0;
        this.fieldIntenseDisplay = (attributes & 0xC) == 8;
        this.fieldSelectorPen = (attributes & 0xC) == 4 || (attributes & 0xC) == 8;
        this.fieldModifed = (attributes & 1) == 1;
    }

    public OrderStartField(boolean fieldProtected, boolean fieldNumeric, boolean fieldDisplay, boolean fieldIntenseDisplay, boolean fieldSelectorPen, boolean fieldModifed) {
        this.fieldProtected = fieldProtected;
        this.fieldNumeric = fieldNumeric;
        this.fieldDisplay = fieldDisplay;
        this.fieldIntenseDisplay = fieldIntenseDisplay;
        this.fieldSelectorPen = fieldSelectorPen;
        this.fieldModifed = fieldModifed;
    }

    public boolean isFieldProtected() {
        return this.fieldProtected;
    }

    public boolean isFieldNumeric() {
        return this.fieldNumeric;
    }

    public boolean isFieldDisplay() {
        return this.fieldDisplay;
    }

    public boolean isFieldIntenseDisplay() {
        return this.fieldIntenseDisplay;
    }

    public boolean isFieldSelectorPen() {
        return this.fieldSelectorPen;
    }

    public boolean isFieldModifed() {
        return this.fieldModifed;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SF(");
        if (this.fieldProtected) {
            sb.append("Protected ");
        } else {
            sb.append("Unprotected ");
        }
        if (this.fieldNumeric) {
            sb.append("Numeric ");
        } else {
            sb.append("Alphanumeric ");
        }
        if (this.fieldDisplay) {
            sb.append("Display ");
        }
        if (this.fieldIntenseDisplay) {
            sb.append("Intense ");
        }
        if (!this.fieldDisplay && !this.fieldIntenseDisplay) {
            sb.append("Nondisplay ");
        }
        if (this.fieldSelectorPen) {
            sb.append("SelectorPen ");
        }
        if (this.fieldModifed) {
            sb.append("Modified");
        } else {
            sb.append("Unmodified");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public byte[] getBytes() {
        byte[] buffer = new byte[2];
        buffer[0] = 29;
        BitSet bitSet = new BitSet(8);
        bitSet.set(6, false);
        bitSet.set(7, false);
        bitSet.set(5, this.fieldProtected);
        bitSet.set(4, this.fieldNumeric);
        if (!this.fieldDisplay) {
            bitSet.set(3, true);
            bitSet.set(2, true);
        } else if (this.fieldIntenseDisplay) {
            bitSet.set(3, true);
            bitSet.set(2, false);
        } else if (this.fieldSelectorPen) {
            bitSet.set(3, false);
            bitSet.set(2, true);
        }
        bitSet.set(1, false);
        bitSet.set(0, this.fieldModifed);
        if (bitSet.isEmpty()) {
            buffer[1] = 0;
        } else {
            byte preConverted = bitSet.toByteArray()[0];
            buffer[1] = BufferAddress.chars[preConverted];
        }
        return buffer;
    }
}

