/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zos3270.internal.datastream;

import dev.galasa.zos3270.internal.datastream.AbstractOrder;
import dev.galasa.zos3270.internal.datastream.AttributeBackgroundColour;
import dev.galasa.zos3270.internal.datastream.AttributeCharacterSet;
import dev.galasa.zos3270.internal.datastream.AttributeExtendedHighlighting;
import dev.galasa.zos3270.internal.datastream.AttributeForegroundColour;
import dev.galasa.zos3270.internal.datastream.AttributeResetAllAttributes;
import dev.galasa.zos3270.internal.datastream.AttributeTransparency;
import dev.galasa.zos3270.internal.datastream.IAttribute;
import dev.galasa.zos3270.spi.DatastreamException;
import java.nio.ByteBuffer;

public class OrderSetAttribute
extends AbstractOrder {
    public static final byte ID = 40;
    private final IAttribute attribute;

    public OrderSetAttribute(ByteBuffer buffer) throws DatastreamException {
        byte attributeId = buffer.get();
        switch (attributeId) {
            case 0: {
                this.attribute = new AttributeResetAllAttributes(buffer);
                break;
            }
            case 65: {
                this.attribute = new AttributeExtendedHighlighting(buffer);
                break;
            }
            case 66: {
                this.attribute = new AttributeForegroundColour(buffer);
                break;
            }
            case 67: {
                this.attribute = new AttributeCharacterSet(buffer);
                break;
            }
            case 69: {
                this.attribute = new AttributeBackgroundColour(buffer);
                break;
            }
            case 70: {
                this.attribute = new AttributeTransparency(buffer);
                break;
            }
            default: {
                throw new DatastreamException("Unrecognised attribute in SA, '" + attributeId + "'");
            }
        }
    }

    @Override
    public byte[] getBytes() {
        throw new UnsupportedOperationException("Not available yet");
    }

    public IAttribute getAttribute() {
        return this.attribute;
    }
}

