/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zos3270.internal.datastream;

import dev.galasa.zos3270.internal.datastream.AbstractOrder;
import dev.galasa.zos3270.internal.datastream.BufferAddress;
import dev.galasa.zos3270.spi.DatastreamException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class OrderRepeatToAddress
extends AbstractOrder {
    private static final Charset ebcdic = Charset.forName("Cp037");
    public static final byte ID = 60;
    private final BufferAddress bufferAddress;
    private final char repeatChar;

    public OrderRepeatToAddress(ByteBuffer buffer) throws DatastreamException {
        this.bufferAddress = new BufferAddress(buffer);
        byte[] charByte = new byte[]{buffer.get()};
        if (charByte[0] == -1) {
            charByte[0] = 0;
        }
        this.repeatChar = ebcdic.decode(ByteBuffer.wrap(charByte)).array()[0];
    }

    public OrderRepeatToAddress(char repeatChar, BufferAddress bufferAddress) {
        this.bufferAddress = bufferAddress;
        this.repeatChar = repeatChar;
    }

    @Override
    public String toString() {
        return "RA(" + this.repeatChar + "," + this.bufferAddress + ")";
    }

    public int getBufferAddress() {
        return this.bufferAddress.getBufferAddress();
    }

    public char getChar() {
        return this.repeatChar;
    }

    @Override
    public byte[] getBytes() {
        byte[] ba = this.bufferAddress.getCharRepresentation();
        byte[] buffer = new byte[]{60, ba[0], ba[1], String.valueOf(this.repeatChar).getBytes(ebcdic)[0]};
        return buffer;
    }
}

