/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zos3270.internal.datastream;

import dev.galasa.zos3270.spi.DatastreamException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class BufferAddress {
    protected static final byte[] chars = new byte[]{64, -63, -62, -61, -60, -59, -58, -57, -56, -55, 74, 75, 76, 77, 78, 79, 80, -47, -46, -45, -44, -43, -42, -41, -40, -39, 90, 91, 92, 93, 94, 95, 96, 97, -30, -29, -28, -27, -26, -25, -24, -23, 106, 107, 108, 109, 110, 111, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, 122, 123, 124, 125, 126, 127};
    private int address = 0;

    public BufferAddress(ByteBuffer buffer) throws DatastreamException {
        byte[] data = new byte[4];
        try {
            data[0] = 0;
            data[1] = 0;
            data[2] = buffer.get();
            data[3] = buffer.get();
        }
        catch (BufferUnderflowException e) {
            throw new DatastreamException("Buffer Address terminated too early", e);
        }
        ByteBuffer toInt = ByteBuffer.wrap(data);
        int preConv = toInt.getInt();
        if ((preConv & 0xC000) == 0) {
            this.address = preConv;
        } else {
            int left = (preConv & 0x3F00) >> 2;
            int right = preConv & 0x3F;
            this.address = left | right;
        }
    }

    public BufferAddress(int address) {
        this.address = address;
    }

    public byte[] getCharRepresentation() {
        int left = (this.address & 0xFC0) >> 6;
        int right = this.address & 0x3F;
        byte[] output = new byte[]{chars[left], chars[right]};
        return output;
    }

    public int getBufferAddress() {
        return this.address;
    }

    public ByteBuffer getByteBufferAddress() {
        return ByteBuffer.wrap(this.getCharRepresentation());
    }

    public String toString() {
        return Integer.toString(this.address);
    }

    public static byte[] getAddressChars() {
        return chars;
    }
}

