/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zos3270.internal.datastream;

import dev.galasa.zos3270.internal.datastream.CommandEraseWrite;
import dev.galasa.zos3270.internal.datastream.CommandEraseWriteAlternate;
import dev.galasa.zos3270.internal.datastream.CommandReadBuffer;
import dev.galasa.zos3270.internal.datastream.CommandReadModified;
import dev.galasa.zos3270.internal.datastream.CommandReadModifiedAll;
import dev.galasa.zos3270.internal.datastream.CommandWrite;
import dev.galasa.zos3270.internal.datastream.CommandWriteStructured;
import dev.galasa.zos3270.spi.DatastreamException;

public abstract class AbstractCommandCode {
    public static final byte WRITE = -15;
    public static final byte ERASE_WRITE = -11;
    public static final byte ERASE_WRITE_ALTERNATE = 126;
    public static final byte READ_BUFFER = -14;
    public static final byte READ_MODIFIED = -10;
    public static final byte READ_MODIFIED_ALL = 110;
    public static final byte ERASE_ALL_UNPROTECTED = 111;
    public static final byte WRITE_STRUCTURED = -13;
    public static final byte NONSNA_WRITE = 1;
    public static final byte NONSNA_ERASE_WRITE = 5;
    public static final byte NONSNA_ERASE_WRITE_ALTERNATE = 13;
    public static final byte NONSNA_READ_BUFFER = 2;
    public static final byte NONSNA_READ_MODIFIED = 6;
    public static final byte NONSNA_READ_MODIFIED_ALL = 14;
    public static final byte NONSNA_ERASE_ALL_UNPROTECTED = 15;
    public static final byte NONSNA_WRITE_STRUCTURED = 17;

    protected AbstractCommandCode() {
    }

    public static AbstractCommandCode getCommandCode(byte commandCode) throws DatastreamException {
        switch (commandCode) {
            case -11: 
            case 5: {
                return new CommandEraseWrite();
            }
            case 13: 
            case 126: {
                return new CommandEraseWriteAlternate();
            }
            case -15: 
            case 1: {
                return new CommandWrite();
            }
            case -13: 
            case 17: {
                return new CommandWriteStructured();
            }
            case -14: 
            case 2: {
                return new CommandReadBuffer();
            }
            case -10: 
            case 6: {
                return new CommandReadModified();
            }
            case 14: 
            case 110: {
                return new CommandReadModifiedAll();
            }
            case 15: 
            case 111: {
                throw new DatastreamException("Unsupported command code=" + commandCode);
            }
        }
        throw new DatastreamException("Unrecognised command code=" + commandCode);
    }
}

