/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zos3270.internal.comms;

import dev.galasa.zos3270.IDatastreamListener;
import dev.galasa.zos3270.TerminalInterruptedException;
import dev.galasa.zos3270.internal.comms.Inbound3270Message;
import dev.galasa.zos3270.internal.comms.Network;
import dev.galasa.zos3270.internal.datastream.AbstractCommandCode;
import dev.galasa.zos3270.internal.datastream.AbstractOrder;
import dev.galasa.zos3270.internal.datastream.CommandWriteStructured;
import dev.galasa.zos3270.internal.datastream.OrderCarrageReturn;
import dev.galasa.zos3270.internal.datastream.OrderEndOfMedium;
import dev.galasa.zos3270.internal.datastream.OrderEraseUnprotectedToAddress;
import dev.galasa.zos3270.internal.datastream.OrderFormFeed;
import dev.galasa.zos3270.internal.datastream.OrderGraphicsEscape;
import dev.galasa.zos3270.internal.datastream.OrderInsertCursor;
import dev.galasa.zos3270.internal.datastream.OrderNewLine;
import dev.galasa.zos3270.internal.datastream.OrderRepeatToAddress;
import dev.galasa.zos3270.internal.datastream.OrderSetAttribute;
import dev.galasa.zos3270.internal.datastream.OrderSetBufferAddress;
import dev.galasa.zos3270.internal.datastream.OrderStartField;
import dev.galasa.zos3270.internal.datastream.OrderStartFieldExtended;
import dev.galasa.zos3270.internal.datastream.OrderText;
import dev.galasa.zos3270.internal.datastream.StructuredField;
import dev.galasa.zos3270.internal.datastream.WriteControlCharacter;
import dev.galasa.zos3270.spi.DatastreamException;
import dev.galasa.zos3270.spi.NetworkException;
import dev.galasa.zos3270.spi.Screen;
import dev.galasa.zos3270.spi.Terminal;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NetworkThread
extends Thread {
    public static final byte IAC = -1;
    public static final byte DONT = -2;
    public static final byte DO = -3;
    public static final byte WONT = -4;
    public static final byte WILL = -5;
    public static final byte SB = -6;
    public static final byte SE = -16;
    public static final byte EOR = -17;
    public static final byte ASSOCIATE = 0;
    public static final byte TELNET_BINARY = 0;
    public static final byte FUNC_BIND_IMAGE = 0;
    public static final byte CONNECT = 1;
    public static final byte TT_SEND = 1;
    public static final byte FOLLOWS = 1;
    public static final byte DEVICE_TYPE = 2;
    public static final byte RESPONSES = 2;
    public static final byte FUNCTIONS = 3;
    public static final byte IS = 4;
    public static final byte FUNC_SYSREQ = 4;
    public static final byte REASON = 5;
    public static final byte REJECT = 6;
    public static final byte TIMING_MARK = 6;
    public static final byte REQUEST = 7;
    public static final byte SEND = 8;
    public static final byte TERMINAL_TYPE = 24;
    public static final byte TELNET_EOR = 25;
    public static final byte TN3270E = 40;
    public static final byte START_TLS = 46;
    public static final byte CONN_PARTNER = 0;
    public static final byte DEVICE_IN_USE = 1;
    public static final byte INV_ASSOCIATE = 2;
    public static final byte INV_NAME = 3;
    public static final byte INV_DEVICE_TYPE = 4;
    public static final byte TYPE_NAME_ERROR = 5;
    public static final byte UNKNOWN_ERROR = 6;
    public static final byte UNSUPPORTED_REQ = 7;
    public static final byte DT_3270_DATA = 0;
    public static final byte DT_SCS_DATA = 1;
    public static final byte DT_RESPONSE = 2;
    public static final byte DT_BIND_IMAGE = 3;
    public static final byte DT_UNBIND = 4;
    public static final byte DT_NVT_DATA = 5;
    public static final byte DT_REQUEST = 6;
    public static final byte DT_SSCP_LU_DATA = 7;
    public static final byte DT_PRINT_EOJ = 8;
    public static final Charset ascii7 = Charset.forName("us-ascii");
    private InputStream inputStream;
    private final Screen screen;
    private final Network network;
    private final Terminal terminal;
    private boolean telnetSessionStarted = false;
    private boolean basicTelnetDatastream = false;
    private boolean endOfStream = false;
    private static Log logger = LogFactory.getLog(NetworkThread.class);
    private final ArrayList<String> possibleDeviceTypes = new ArrayList();
    private String selectedDeviceType;
    private ByteArrayOutputStream commandSoFar;

    public NetworkThread(Terminal terminal, Screen screen, Network network, InputStream inputStream) {
        this(terminal, screen, network, inputStream, null);
    }

    public NetworkThread(Terminal terminal, Screen screen, Network network, InputStream inputStream, List<String> deviceTypes) {
        this.screen = screen;
        this.network = network;
        this.inputStream = inputStream;
        this.terminal = terminal;
        if (deviceTypes == null || deviceTypes.isEmpty()) {
            this.possibleDeviceTypes.add("IBM-DYNAMIC");
            this.possibleDeviceTypes.add("IBM-3278-2");
        } else {
            this.possibleDeviceTypes.addAll(deviceTypes);
        }
    }

    @Override
    public void run() {
        logger.trace((Object)("Starting network thread on terminal " + this.terminal.getId()));
        while (!this.endOfStream) {
            try {
                this.processMessage(this.inputStream);
            }
            catch (NetworkException e) {
                logger.error((Object)"Problem with Network Thread", (Throwable)e);
                break;
            }
            catch (IOException e) {
                if (e.getMessage().contains("Socket closed")) break;
                logger.error((Object)"Problem with Network Thread", (Throwable)e);
                break;
            }
        }
        try {
            this.screen.networkClosed();
        }
        catch (TerminalInterruptedException e) {
            logger.error((Object)"Problem locking keyboard on network close", (Throwable)e);
        }
        logger.trace((Object)("Ending network thread on terminal " + this.terminal.getId()));
        this.terminal.networkClosed();
    }

    public void processMessage(InputStream messageStream) throws IOException, NetworkException {
        this.commandSoFar = new ByteArrayOutputStream();
        Byte header = this.readByte(messageStream);
        if (header == null) {
            return;
        }
        if (header == -1) {
            this.doIac(messageStream);
            return;
        }
        if (this.basicTelnetDatastream) {
            this.telnetSessionStarted = true;
            ByteBuffer buffer = NetworkThread.readTerminatedMessage(header, messageStream);
            Inbound3270Message inbound3270Message = this.process3270Data(buffer);
            this.screen.processInboundMessage(inbound3270Message);
            return;
        }
        this.telnetSessionStarted = true;
        ByteBuffer buffer = NetworkThread.readTerminatedMessage(header, messageStream);
        if (buffer.remaining() < 5) {
            throw new NetworkException("Missing 5 bytes of the TN3270E datastream header");
        }
        byte tn3270eHeader = buffer.get();
        if (tn3270eHeader == 3) {
            logger.trace((Object)"BIND_IMAGE received");
            return;
        }
        if (tn3270eHeader == 4) {
            logger.trace((Object)"UNBIND_IMAGE received");
            return;
        }
        if (tn3270eHeader != 0) {
            throw new NetworkException("Was expecting a TN3270E datastream header of zeros - " + this.reportCommandSoFar());
        }
        buffer.get(new byte[4]);
        Inbound3270Message inbound3270Message = this.process3270Data(buffer);
        this.screen.processInboundMessage(inbound3270Message);
    }

    private void doIac(InputStream messageStream) throws NetworkException, IOException {
        Byte iac = this.readByte(messageStream);
        if (iac == null) {
            throw new NetworkException("Unrecognised IAC terminated early - " + this.reportCommandSoFar());
        }
        if (iac == -3) {
            this.doIacDo(messageStream);
            return;
        }
        if (iac == -2) {
            this.doIacDont(messageStream);
            return;
        }
        if (iac == -6) {
            this.doIacSb(messageStream);
            return;
        }
        if (iac == -5) {
            this.doIacWill(messageStream);
            return;
        }
        if (iac == -4) {
            this.doIacWont(messageStream);
            return;
        }
        throw new NetworkException("Unrecognised IAC Command - " + this.reportCommandSoFar());
    }

    private void doIacSb(InputStream messageStream) throws NetworkException, IOException {
        ByteBuffer remainingSb = this.readTerminatedSB(messageStream);
        byte sb = remainingSb.get();
        if (sb == 40) {
            this.doIacSbTn3270e(remainingSb);
            return;
        }
        if (sb == 46) {
            this.doIacSbStartTls(remainingSb);
            return;
        }
        if (sb == 24) {
            this.doIacSbTerminalType(remainingSb);
            return;
        }
        throw new NetworkException("Unrecognised IAC SB Command - " + this.reportCommandSoFar());
    }

    private void doIacWill(InputStream messageStream) throws NetworkException, IOException {
        Byte will = this.readByte(messageStream);
        if (will == null) {
            throw new NetworkException("Unrecognised IAC WILL terminated early - " + this.reportCommandSoFar());
        }
        throw new NetworkException("Unrecognised IAC WILL Command - " + this.reportCommandSoFar());
    }

    private void doIacWont(InputStream messageStream) throws NetworkException, IOException {
        Byte will = this.readByte(messageStream);
        if (will == null) {
            throw new NetworkException("Unrecognised IAC WONT terminated early - " + this.reportCommandSoFar());
        }
        if (will == 6) {
            return;
        }
        throw new NetworkException("Unrecognised IAC WONT Command - " + this.reportCommandSoFar());
    }

    private void doIacSbTn3270e(ByteBuffer remainingSb) throws NetworkException, IOException {
        byte sb = remainingSb.get();
        if (sb == 8) {
            this.doIacSbTn3270eSend(remainingSb);
            return;
        }
        if (sb == 2) {
            this.doIacSbTn3270eDeviceType(remainingSb);
            return;
        }
        if (sb == 3) {
            this.doIacSbTn3270eFunctions(remainingSb);
            return;
        }
        throw new NetworkException("Unrecognised IAC SB TN3270E Command - " + this.reportCommandSoFar());
    }

    private void doIacSbStartTls(ByteBuffer remainingSb) throws NetworkException, IOException {
        byte sb = remainingSb.get();
        if (sb == 1) {
            this.doIacSbStartTlsFollows(remainingSb);
            return;
        }
        throw new NetworkException("Unrecognised IAC SB START_TLS Command - " + this.reportCommandSoFar());
    }

    private void doIacSbStartTlsFollows(ByteBuffer remainingSb) throws NetworkException, IOException {
        logger.trace((Object)"TN3270E switching to TLS");
        Socket newSocket = this.network.startTls();
        this.inputStream = newSocket.getInputStream();
        this.network.switchedSSL(true);
        logger.trace((Object)"TN3270E switched to TLS");
    }

    private void doIacSbTn3270eSend(ByteBuffer remainingSb) throws NetworkException, IOException {
        byte sb = remainingSb.get();
        if (sb == 2) {
            this.doIacSbTn3270eSendDeviceType(remainingSb);
            return;
        }
        throw new NetworkException("Unrecognised IAC SB TN3270E SEND Command - " + this.reportCommandSoFar());
    }

    private void doIacSbTn3270eSendDeviceType(ByteBuffer remainingSb) throws NetworkException, IOException {
        logger.trace((Object)"IAC SB TN3270E SEND DEVICE_TYPE received from server");
        this.requestDeviceTypeDeviceName();
    }

    private void doIacSbTerminalType(ByteBuffer remainingSb) throws NetworkException, IOException {
        byte sb = remainingSb.get();
        if (sb == 1) {
            this.doIacSbTerminalTypeSend(remainingSb);
            return;
        }
        throw new NetworkException("Unrecognised IAC SB TERMINAL-TYPE Command - " + this.reportCommandSoFar());
    }

    private void doIacSbTerminalTypeSend(ByteBuffer remainingSb) throws NetworkException, IOException {
        logger.trace((Object)"IAC SB TERMINAL-TYPE SEND received from server");
        this.requestTerminalType();
    }

    private void requestDeviceTypeDeviceName() throws NetworkException, IOException {
        if (this.possibleDeviceTypes.isEmpty()) {
            throw new NetworkException("Ran out of TN3270E device types to negotiate for");
        }
        if (this.selectedDeviceType != null) {
            throw new NetworkException("logic error, nothing new to negotiate device type with");
        }
        this.selectedDeviceType = this.possibleDeviceTypes.remove(0);
        logger.trace((Object)("Requesting TN3270E device type " + this.selectedDeviceType));
        byte[] deviceType = this.selectedDeviceType.getBytes(ascii7);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(-1);
        baos.write(-6);
        baos.write(40);
        baos.write(2);
        baos.write(7);
        baos.write(deviceType);
        baos.write(-1);
        baos.write(-16);
        this.network.sendIac(baos.toByteArray());
    }

    private void requestTerminalType() throws NetworkException, IOException {
        if (this.possibleDeviceTypes.isEmpty()) {
            throw new NetworkException("Ran out of terminal types to negotiate for");
        }
        if (this.selectedDeviceType != null) {
            throw new NetworkException("logic error, nothing new to negotiate device type with");
        }
        this.selectedDeviceType = this.possibleDeviceTypes.remove(0);
        logger.trace((Object)("Requesting terminal type " + this.selectedDeviceType));
        byte[] deviceType = this.selectedDeviceType.getBytes(ascii7);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(-1);
        baos.write(-6);
        baos.write(24);
        baos.write(0);
        baos.write(deviceType);
        baos.write(-1);
        baos.write(-16);
        this.network.sendIac(baos.toByteArray());
    }

    private void doIacSbTn3270eDeviceType(ByteBuffer remainingSb) throws NetworkException, IOException {
        byte sb = remainingSb.get();
        if (sb == 4) {
            this.doIacSbTn3270eDeviceTypeIs(remainingSb);
            return;
        }
        if (sb == 6) {
            this.doIacSbTn3270eDeviceTypeReject(remainingSb);
            return;
        }
        throw new NetworkException("Unrecognised IAC SB TN3270E DEVICE_TYPE Command - " + this.reportCommandSoFar());
    }

    private void doIacSbTn3270eDeviceTypeIs(ByteBuffer remainingSb) throws NetworkException, IOException {
        byte b;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((b = remainingSb.get()) != 1) {
            baos.write(b);
        }
        this.selectedDeviceType = new String(baos.toByteArray(), ascii7);
        baos = new ByteArrayOutputStream();
        while (remainingSb.hasRemaining() && (b = remainingSb.get()) != -1) {
            baos.write(b);
        }
        String luName = new String(baos.toByteArray(), ascii7);
        logger.trace((Object)("TN3270 device type " + this.selectedDeviceType + " with LU " + luName + " was agreed"));
        this.negotiateFunctions();
    }

    private void doIacSbTn3270eFunctions(ByteBuffer remainingSb) throws NetworkException, IOException {
        byte sb = remainingSb.get();
        if (sb == 4) {
            this.doIacSbTn3270eFunctionsIs(remainingSb);
            return;
        }
        if (sb == 7) {
            this.doIacSbTn3270eFunctionsRequest(remainingSb);
            return;
        }
        throw new NetworkException("Unrecognised IAC SB TN3270E FUNCTIONS Command - " + this.reportCommandSoFar());
    }

    private void doIacSbTn3270eFunctionsRequest(ByteBuffer remainingSb) throws NetworkException, IOException {
        logger.trace((Object)"TN3270E server renegoiating FUNCTIONS");
        boolean bind = false;
        boolean sysreq = false;
        boolean rerequest = false;
        while (remainingSb.hasRemaining()) {
            byte function = remainingSb.get();
            if (function == 0) {
                logger.trace((Object)"TN3270E function BIND_IMAGE requested");
                bind = true;
                continue;
            }
            if (function == 4) {
                logger.trace((Object)"TN3270E function SYSREQ requested");
                sysreq = true;
                continue;
            }
            logger.trace((Object)("Unexpected function on FUNCTIONS REQUEST = 0x" + Hex.encodeHexString((byte[])new byte[]{function}) + ", rejecting"));
            rerequest = true;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(-1);
        baos.write(-6);
        baos.write(40);
        baos.write(3);
        if (rerequest) {
            logger.trace((Object)"Renegotiating FUNCTIONS with :-");
            baos.write(7);
        } else {
            logger.trace((Object)"TN3270E FUNCTIONS accepted with :-");
            baos.write(4);
        }
        if (bind) {
            baos.write(0);
            logger.trace((Object)"     BIND_IMAGE");
        }
        if (sysreq) {
            baos.write(4);
            logger.trace((Object)"     SYSREQ");
        }
        baos.write(-1);
        baos.write(-16);
        this.network.sendIac(baos.toByteArray());
    }

    private void doIacSbTn3270eFunctionsIs(ByteBuffer remainingSb) throws NetworkException, IOException {
        logger.trace((Object)"TN3270E FUNCTIONS IS accepted with :-");
        while (remainingSb.hasRemaining()) {
            byte function = remainingSb.get();
            if (function == 0) {
                logger.trace((Object)"     BIND_IMAGE");
                continue;
            }
            if (function == 4) {
                logger.trace((Object)"     SYSREQ");
                continue;
            }
            throw new NetworkException("Unexpected function on FUNCTIONS IS = 0x" + Hex.encodeHexString((byte[])new byte[]{function}));
        }
        logger.trace((Object)"TN3270E negotiation complete, 3270 datastream should now start");
        this.telnetSessionStarted = true;
    }

    private void negotiateFunctions() throws NetworkException {
        logger.trace((Object)"Requesting TN3270E functions BIND_IMAGE, SYSREQ");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(-1);
        baos.write(-6);
        baos.write(40);
        baos.write(3);
        baos.write(7);
        baos.write(0);
        baos.write(4);
        baos.write(-1);
        baos.write(-16);
        this.network.sendIac(baos.toByteArray());
    }

    private void doIacSbTn3270eDeviceTypeReject(ByteBuffer remainingSb) throws NetworkException, IOException {
        byte sb = remainingSb.get();
        if (sb == 5) {
            this.doIacSbTn3270eDeviceTypeRejectReason(remainingSb);
            return;
        }
        throw new NetworkException("Unrecognised IAC SB TN3270E DEVICE_TYPE REJECT Command - " + this.reportCommandSoFar());
    }

    private void doIacSbTn3270eDeviceTypeRejectReason(ByteBuffer remainingSb) throws NetworkException, IOException {
        byte reasonCode = remainingSb.get();
        switch (reasonCode) {
            case 0: {
                throw new NetworkException("Device negotiation failed due to CONN_PARTNER");
            }
            case 1: {
                throw new NetworkException("Device negotiation failed due to DEVICE_IN_USE");
            }
            case 2: {
                throw new NetworkException("Device negotiation failed due to INV_ASSOCIATE");
            }
            case 3: {
                throw new NetworkException("Device negotiation failed due to INV_NAME");
            }
            case 4: {
                logger.trace((Object)("TN3270 device type " + this.selectedDeviceType + " was rejected as invalid INV_DEVICE_TYPE"));
                this.selectedDeviceType = null;
                this.requestDeviceTypeDeviceName();
                return;
            }
            case 5: {
                throw new NetworkException("Device negotiation failed due to TYPE_NAME_ERROR");
            }
            case 6: {
                throw new NetworkException("Device negotiation failed due to UNKNOWN_ERROR");
            }
            case 7: {
                throw new NetworkException("Device negotiation failed due to UNSUPPORTED_REQ");
            }
        }
        throw new NetworkException("Unrecognised reason code for rejected device type =" + reasonCode);
    }

    private void doIacDo(InputStream messageStream) throws NetworkException, IOException {
        Byte iac = this.readByte(messageStream);
        if (iac == null) {
            throw new NetworkException("Unrecognised IAC DO terminated early - " + this.reportCommandSoFar());
        }
        if (iac == 6) {
            this.doIacDoTimingMark(messageStream);
            return;
        }
        if (iac == 40) {
            this.doIacDoTn3270e(messageStream);
            return;
        }
        if (iac == 46) {
            this.doIacDoStartTls(messageStream);
            return;
        }
        if (iac == 24) {
            this.doIacDoTerminalType(messageStream);
            return;
        }
        if (iac == 25) {
            this.doIacDoTelnetEor(messageStream);
            return;
        }
        if (iac == 0) {
            this.doIacDoTelnetBinary(messageStream);
            return;
        }
        throw new NetworkException("Unrecognised IAC DO Command - " + this.reportCommandSoFar());
    }

    private void doIacDont(InputStream messageStream) throws NetworkException, IOException {
        Byte dont = this.readByte(messageStream);
        if (dont == null) {
            throw new NetworkException("Unrecognised IAC DO terminated early - " + this.reportCommandSoFar());
        }
        if (dont == 40) {
            logger.trace((Object)"Received IAC DONT TN3270E");
            if (this.selectedDeviceType != null) {
                this.possibleDeviceTypes.add(0, this.selectedDeviceType);
                this.selectedDeviceType = null;
            }
            return;
        }
        if (dont == 6) {
            return;
        }
        throw new NetworkException("Unrecognised IAC DONT Command - " + this.reportCommandSoFar());
    }

    private void doIacDoTimingMark(InputStream messageStream) throws NetworkException {
        logger.trace((Object)"timing received");
        this.network.sendIac(new byte[]{-1, -5, 6});
    }

    private void doIacDoTelnetEor(InputStream messageStream) throws NetworkException, IOException {
        Byte iac = this.readByte(messageStream);
        if (iac == null) {
            throw new NetworkException("Unrecognised IAC DO EOR terminated early - " + this.reportCommandSoFar());
        }
        if (iac == -1) {
            this.doIacDoTelnetEorIac(messageStream);
            return;
        }
        throw new NetworkException("Unrecognised IAC DO EOR Command - " + this.reportCommandSoFar());
    }

    private void doIacDoTelnetEorIac(InputStream messageStream) throws NetworkException, IOException {
        Byte iac = this.readByte(messageStream);
        if (iac == null) {
            throw new NetworkException("Unrecognised IAC DO EOR IAC terminated early - " + this.reportCommandSoFar());
        }
        if (iac == -5) {
            this.doIacDoTelnetEorIacWill(messageStream);
            return;
        }
        throw new NetworkException("Unrecognised IAC DO EOR WILL Command - " + this.reportCommandSoFar());
    }

    private void doIacDoTelnetEorIacWill(InputStream messageStream) throws NetworkException, IOException {
        Byte iac = this.readByte(messageStream);
        if (iac == null) {
            throw new NetworkException("Unrecognised IAC DO EOR IAC WILL terminated early - " + this.reportCommandSoFar());
        }
        if (iac == 25) {
            this.doIacDoTelnetEorIacWillEor(messageStream);
            return;
        }
        throw new NetworkException("Unrecognised IAC DO EOR WILL Command - " + this.reportCommandSoFar());
    }

    private void doIacDoTelnetEorIacWillEor(InputStream messageStream) throws NetworkException, IOException {
        logger.trace((Object)"IAC DO EOR WILL EOR received from server");
        this.network.sendIac(new byte[]{-1, -5, 25, -1, -3, 25});
        this.basicTelnetDatastream = true;
        this.network.setBasicTelnet(true);
    }

    private void doIacDoTelnetBinary(InputStream messageStream) throws NetworkException, IOException {
        Byte iac = this.readByte(messageStream);
        if (iac == null) {
            throw new NetworkException("Unrecognised IAC DO BINARY terminated early - " + this.reportCommandSoFar());
        }
        if (iac == -1) {
            this.doIacDoTelnetBinaryIac(messageStream);
            return;
        }
        throw new NetworkException("Unrecognised IAC DO BINARY Command - " + this.reportCommandSoFar());
    }

    private void doIacDoTelnetBinaryIac(InputStream messageStream) throws NetworkException, IOException {
        Byte iac = this.readByte(messageStream);
        if (iac == null) {
            throw new NetworkException("Unrecognised IAC DO BINARY IAC terminated early - " + this.reportCommandSoFar());
        }
        if (iac == -5) {
            this.doIacDoTelnetBinaryWill(messageStream);
            return;
        }
        throw new NetworkException("Unrecognised IAC DO BINARY WILL Command - " + this.reportCommandSoFar());
    }

    private void doIacDoTelnetBinaryWill(InputStream messageStream) throws NetworkException, IOException {
        Byte iac = this.readByte(messageStream);
        if (iac == null) {
            throw new NetworkException("Unrecognised IAC DO BINARY IAC WILL terminated early - " + this.reportCommandSoFar());
        }
        if (iac == 0) {
            this.doIacDoTelnetBinaryWillBinary(messageStream);
            return;
        }
        throw new NetworkException("Unrecognised IAC DO BINARY WILL Command - " + this.reportCommandSoFar());
    }

    private void doIacDoTelnetBinaryWillBinary(InputStream messageStream) throws NetworkException, IOException {
        logger.trace((Object)"IAC DO BINARY WILL BINARY received from server");
        this.network.sendIac(new byte[]{-1, -5, 0, -1, -3, 0});
    }

    private void doIacDoTerminalType(InputStream messageStream) throws NetworkException {
        logger.trace((Object)"IAC DO TERMINAL-TYPE received from server");
        this.network.sendIac(new byte[]{-1, -5, 24});
    }

    private void doIacDoTn3270e(InputStream messageStream) throws NetworkException {
        logger.trace((Object)"IAC DO TN3270E received from server, responding with IAC WILL TN3270E");
        this.network.sendIac(new byte[]{-1, -5, 40});
        this.network.setBasicTelnet(false);
    }

    private void doIacDoStartTls(InputStream messageStream) throws NetworkException, IOException {
        if (this.network.isDoStartTls()) {
            logger.trace((Object)"IAC DO START_TLS received from server, agreeing to switch to TLS");
            this.network.sendIac(new byte[]{-1, -5, 46, -1, -6, 46, 1, -1, -16});
        } else {
            logger.trace((Object)"IAC DO START_TLS received from server, refusing");
            this.network.sendIac(new byte[]{-1, -4, 46});
        }
    }

    private Byte readByte(InputStream messageStream) throws IOException {
        byte[] b = new byte[1];
        int length = messageStream.read(b);
        if (length == -1) {
            this.endOfStream = true;
            logger.trace((Object)"Terminal has been disconnected");
            return null;
        }
        if (length == 0) {
            return null;
        }
        this.commandSoFar.write(b);
        return b[0];
    }

    private String reportCommandSoFar() {
        return Hex.encodeHexString((byte[])this.commandSoFar.toByteArray());
    }

    public Inbound3270Message process3270Data(ByteBuffer buffer) throws NetworkException {
        AbstractCommandCode commandCode;
        if (logger.isTraceEnabled() || !this.screen.getDatastreamListeners().isEmpty()) {
            String hex = new String(Hex.encodeHex((byte[])buffer.array()));
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("inbound=" + hex));
            }
            for (IDatastreamListener listener : this.screen.getDatastreamListeners()) {
                listener.datastreamUpdate(IDatastreamListener.DatastreamDirection.INBOUND, hex);
            }
        }
        if ((commandCode = AbstractCommandCode.getCommandCode(buffer.get())) instanceof CommandWriteStructured) {
            return NetworkThread.processStructuredFields((CommandWriteStructured)commandCode, buffer);
        }
        return NetworkThread.process3270Datastream(commandCode, buffer);
    }

    public static Inbound3270Message process3270Datastream(AbstractCommandCode commandCode, ByteBuffer buffer) throws DatastreamException {
        if (!buffer.hasRemaining()) {
            return new Inbound3270Message(commandCode, null, null);
        }
        WriteControlCharacter writeControlCharacter = new WriteControlCharacter(buffer.get());
        List<AbstractOrder> orders = NetworkThread.processOrders(buffer);
        return new Inbound3270Message(commandCode, writeControlCharacter, orders);
    }

    public static List<AbstractOrder> processOrders(ByteBuffer buffer) throws DatastreamException {
        OrderText orderText = null;
        ArrayList<AbstractOrder> orders = new ArrayList<AbstractOrder>();
        while (buffer.remaining() > 0) {
            byte orderByte = buffer.get();
            if (orderByte > 0 && orderByte <= 63) {
                orderText = null;
                AbstractOrder order = null;
                switch (orderByte) {
                    case 17: {
                        order = new OrderSetBufferAddress(buffer);
                        break;
                    }
                    case 60: {
                        order = new OrderRepeatToAddress(buffer);
                        break;
                    }
                    case 29: {
                        order = new OrderStartField(buffer);
                        break;
                    }
                    case 41: {
                        order = new OrderStartFieldExtended(buffer);
                        break;
                    }
                    case 40: {
                        order = new OrderSetAttribute(buffer);
                        break;
                    }
                    case 19: {
                        order = new OrderInsertCursor();
                        break;
                    }
                    case 18: {
                        order = new OrderEraseUnprotectedToAddress(buffer);
                        break;
                    }
                    case 21: {
                        order = new OrderNewLine();
                        break;
                    }
                    case 12: {
                        order = new OrderFormFeed();
                        break;
                    }
                    case 13: {
                        order = new OrderCarrageReturn();
                        break;
                    }
                    case 25: {
                        order = new OrderEndOfMedium();
                        break;
                    }
                    case 8: {
                        order = new OrderGraphicsEscape(buffer);
                        break;
                    }
                    default: {
                        String byteHex = Hex.encodeHexString((byte[])new byte[]{orderByte});
                        logger.trace((Object)("Invalid byte detected in datastream, unrecognised byte order or text byte - 0x" + byteHex));
                        order = new OrderText(" ");
                    }
                }
                orders.add(order);
                continue;
            }
            if (orderText == null) {
                orderText = new OrderText();
                orders.add(orderText);
            }
            orderText.append(orderByte);
        }
        return orders;
    }

    public static Inbound3270Message processStructuredFields(CommandWriteStructured commandCode, ByteBuffer buffer) throws NetworkException {
        ArrayList<StructuredField> structuredFields = new ArrayList<StructuredField>();
        while (buffer.remaining() > 0) {
            int length = buffer.getShort();
            if (length == 0) {
                if (buffer.remaining() == 0) break;
                length = buffer.remaining() + 2;
            }
            byte[] sfData = new byte[length - 2];
            buffer.get(sfData);
            structuredFields.add(StructuredField.getStructuredField(sfData));
        }
        return new Inbound3270Message(commandCode, structuredFields);
    }

    public static ByteBuffer readTerminatedMessage(byte header, InputStream messageStream) throws IOException, NetworkException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(header);
        byte[] b = new byte[1];
        boolean lastByteFF = false;
        boolean terminated = false;
        while (messageStream.read(b) == 1) {
            if (b[0] == -1) {
                if (lastByteFF) {
                    byteArrayOutputStream.write(b);
                    lastByteFF = false;
                    continue;
                }
                lastByteFF = true;
                continue;
            }
            if (b[0] == -17 && lastByteFF) {
                terminated = true;
                break;
            }
            byteArrayOutputStream.write(b);
        }
        if (!terminated) {
            throw new NetworkException("3270 message did not terminate with IAC EOR");
        }
        byte[] bytes = byteArrayOutputStream.toByteArray();
        return ByteBuffer.wrap(bytes);
    }

    public ByteBuffer readTerminatedSB(InputStream messageStream) throws IOException, NetworkException {
        Byte b;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean lastByteFF = false;
        boolean terminated = false;
        while ((b = this.readByte(messageStream)) != null) {
            if (b == -1) {
                if (lastByteFF) {
                    byteArrayOutputStream.write(b.byteValue());
                    lastByteFF = false;
                    continue;
                }
                lastByteFF = true;
                continue;
            }
            if (b == -16 && lastByteFF) {
                terminated = true;
                break;
            }
            byteArrayOutputStream.write(b.byteValue());
        }
        if (!terminated) {
            throw new NetworkException("IAC SB message did not terminate with IAC SE");
        }
        byte[] bytes = byteArrayOutputStream.toByteArray();
        return ByteBuffer.wrap(bytes);
    }

    public boolean isStarted() {
        return this.telnetSessionStarted;
    }
}

