/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zos3270.internal.comms;

import dev.galasa.zos3270.spi.NetworkException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NetworkServer {
    public static final Charset ascii7 = Charset.forName("us-ascii");
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Socket socket;
    private final OutputStream outputStream;
    private final InputStream inputStream;
    private String deviceName;

    public NetworkServer(Socket socket) throws NetworkException {
        try {
            this.socket = socket;
            this.socket.setTcpNoDelay(true);
            this.socket.setKeepAlive(true);
            this.inputStream = this.socket.getInputStream();
            this.outputStream = this.socket.getOutputStream();
            this.negotiate(this.inputStream, this.outputStream);
        }
        catch (IOException e) {
            throw new NetworkException("Unable to initialise the server", e);
        }
    }

    public void close() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                this.logger.warn((Object)"Problem closing socket", (Throwable)e);
            }
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void negotiate(InputStream inputStream, OutputStream outputStream) throws NetworkException {
        try {
            byte[] doTN3270 = new byte[]{-1, -3, 40};
            outputStream.write(doTN3270);
            outputStream.flush();
            NetworkServer.expect(inputStream, -1, -5, 40);
            byte[] sendDeviceType = new byte[]{-1, -6, 40, 8, 2, -1, -16};
            outputStream.write(sendDeviceType);
            outputStream.flush();
            String deviceType = "";
            boolean gotCorrectDeviceType = false;
            while (!gotCorrectDeviceType) {
                ByteBuffer buffer = NetworkServer.readSbSeMessage(inputStream);
                NetworkServer.expect(buffer, 2, 7);
                deviceType = "";
                this.deviceName = "";
                boolean readingType = true;
                while (buffer.hasRemaining()) {
                    byte[] b = new byte[1];
                    buffer.get(b);
                    if (b[0] == 1 || b[0] == 0) {
                        readingType = false;
                        continue;
                    }
                    String bs = new String(b, ascii7);
                    if (readingType) {
                        deviceType = deviceType + bs;
                        continue;
                    }
                    this.deviceName = this.deviceName + bs;
                }
                if ("IBM-3278-2".equals(deviceType) || "IBM-3278-2-E".equals(deviceType) || "IBM-3278-3".equals(deviceType) || "IBM-3278-3-E".equals(deviceType) || "IBM-3278-4".equals(deviceType) || "IBM-3278-4-E".equals(deviceType) || "IBM-3278-5".equals(deviceType) || "IBM-3278-5-E".equals(deviceType) || "IBM-3279-2".equals(deviceType) || "IBM-3279-2-E".equals(deviceType) || "IBM-3279-3".equals(deviceType) || "IBM-DYNAMIC".equals(deviceType)) break;
                byte[] rejectDeviceType = new byte[]{-1, -6, 40, 2, 6, 5, 4, -1, -16};
                outputStream.write(rejectDeviceType);
                outputStream.flush();
            }
            if (this.deviceName.isEmpty()) {
                this.deviceName = "TERM0001";
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(-1);
            baos.write(-6);
            baos.write(40);
            baos.write(2);
            baos.write(4);
            baos.write(deviceType.getBytes(ascii7));
            baos.write(1);
            baos.write(this.deviceName.getBytes(ascii7));
            baos.write(-1);
            baos.write(-16);
            outputStream.write(baos.toByteArray());
            outputStream.flush();
            ByteBuffer buffer = NetworkServer.readSbSeMessage(inputStream);
            NetworkServer.expect(buffer, 3, 7);
            byte[] noFunctions = new byte[]{-1, -6, 40, 3, 4, -1, -16};
            outputStream.write(noFunctions);
            outputStream.flush();
        }
        catch (IOException e) {
            throw new NetworkException("IOException during terminal negotiation", e);
        }
    }

    public void sendDatastream(byte[] outboundDatastream) throws NetworkException {
        this.sendDatastream(this.outputStream, outboundDatastream);
    }

    public void sendDatastream(OutputStream outputStream, byte[] outboundDatastream) throws NetworkException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            byte[] header = new byte[]{0, 0, 0, 0, 0};
            byte[] trailer = new byte[]{-1, -17};
            baos.write(header);
            baos.write(outboundDatastream);
            baos.write(trailer);
            outputStream.write(baos.toByteArray());
            outputStream.flush();
        }
        catch (IOException e) {
            throw new NetworkException("Unable to write outbound datastream", e);
        }
    }

    public static void expect(InputStream inputStream, byte ... expected) throws IOException, NetworkException {
        byte[] received = new byte[expected.length];
        int length = inputStream.read(received);
        if (length != expected.length) {
            throw new NetworkException("Expected " + expected.length + " but received only " + length + " bytes");
        }
        if (!Arrays.equals(expected, received)) {
            String expectedString = Hex.encodeHexString((byte[])expected);
            String receivedString = Hex.encodeHexString((byte[])received);
            throw new NetworkException("Expected " + expectedString + " but received " + receivedString);
        }
    }

    public static void expect(ByteBuffer buffer, byte ... expected) throws NetworkException {
        byte[] received = new byte[expected.length];
        buffer.get(received);
        if (!Arrays.equals(expected, received)) {
            String expectedString = Hex.encodeHexString((byte[])expected);
            String receivedString = Hex.encodeHexString((byte[])received);
            throw new NetworkException("Expected " + expectedString + " but received " + receivedString);
        }
    }

    public static ByteBuffer readSbSeMessage(InputStream messageStream) throws IOException, NetworkException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        NetworkServer.expect(messageStream, -1, -6, 40);
        byte[] b = new byte[1];
        boolean lastByteFF = false;
        boolean terminated = false;
        while (messageStream.read(b) == 1) {
            if (b[0] == -1) {
                if (lastByteFF) {
                    byteArrayOutputStream.write(b);
                    lastByteFF = false;
                    continue;
                }
                lastByteFF = true;
                continue;
            }
            if (b[0] == -16 && lastByteFF) {
                terminated = true;
                break;
            }
            byteArrayOutputStream.write(b);
        }
        if (!terminated) {
            throw new NetworkException("3270 message did not terminate with IAC SE");
        }
        byte[] bytes = byteArrayOutputStream.toByteArray();
        return ByteBuffer.wrap(bytes);
    }

    public String getDeviceName() {
        return this.deviceName;
    }
}

