/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zos3270.internal.comms;

import dev.galasa.zos3270.spi.NetworkException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Network {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final String host;
    private final int port;
    private final boolean ssl;
    private final String terminalId;
    private boolean switchedSSL = false;
    private boolean doStartTls = true;
    private Socket socket;
    private OutputStream outputStream;
    private InputStream inputStream;
    private KeepAlive keepAlive;
    private Instant lastSend = Instant.now();
    private Exception errorException;
    private boolean basicTelnet = false;

    public Network(String host, int port, String terminalId) {
        this(host, port, false, terminalId);
    }

    public Network(String host, int port, boolean ssl, String terminalId) {
        this.host = host;
        this.port = port;
        this.ssl = ssl;
        this.terminalId = terminalId;
    }

    public boolean connectClient() throws NetworkException {
        if (this.socket != null) {
            if (this.socket.isConnected()) {
                return true;
            }
            this.close();
        }
        Socket newSocket = null;
        try {
            newSocket = this.createSocket();
            newSocket.setTcpNoDelay(true);
            newSocket.setKeepAlive(true);
            this.socket = newSocket;
            this.inputStream = this.socket.getInputStream();
            this.outputStream = this.socket.getOutputStream();
            newSocket = null;
            this.keepAlive = new KeepAlive();
            this.keepAlive.start();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new NetworkException("Unable to connect to Telnet server", e);
        }
        finally {
            if (newSocket != null) {
                try {
                    newSocket.close();
                }
                catch (IOException e) {
                    this.logger.error((Object)"Failed to close the socket", (Throwable)e);
                }
            }
        }
    }

    public void setDoStartTls(boolean doStartTls) {
        this.doStartTls = doStartTls;
    }

    public boolean isDoStartTls() {
        return this.doStartTls;
    }

    public boolean isConnected() {
        return this.socket != null;
    }

    public Socket createSocket() throws IOException, NoSuchAlgorithmException, KeyManagementException {
        Socket newSocket = null;
        if (!this.ssl) {
            newSocket = new Socket(this.host, this.port);
        } else {
            boolean ibmJdk = System.getProperty("java.vendor").contains("IBM");
            SSLContext sslContext = ibmJdk ? SSLContext.getInstance("SSL_TLSv2") : SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, new TrustManager[]{new TrustAllCerts()}, new SecureRandom());
            newSocket = sslContext.getSocketFactory().createSocket(this.host, this.port);
            ((SSLSocket)newSocket).startHandshake();
        }
        newSocket.setTcpNoDelay(true);
        newSocket.setKeepAlive(true);
        return newSocket;
    }

    public void close() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                this.logger.error((Object)"Failed to close the socket", (Throwable)e);
            }
            this.socket = null;
            this.inputStream = null;
            this.outputStream = null;
            this.keepAlive.shutdown = true;
            this.keepAlive.interrupt();
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public Socket startTls() throws NetworkException {
        try {
            boolean ibmJdk = System.getProperty("java.vendor").contains("IBM");
            SSLContext sslContext = ibmJdk ? SSLContext.getInstance("SSL_TLSv2") : SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, new TrustManager[]{new TrustAllCerts()}, new SecureRandom());
            Socket tlsSocket = sslContext.getSocketFactory().createSocket(this.socket, this.host, this.port, false);
            ((SSLSocket)tlsSocket).startHandshake();
            tlsSocket.setTcpNoDelay(true);
            tlsSocket.setKeepAlive(true);
            this.socket = tlsSocket;
            this.inputStream = tlsSocket.getInputStream();
            this.outputStream = tlsSocket.getOutputStream();
            return tlsSocket;
        }
        catch (Exception e) {
            throw new NetworkException("Problem negotiating TLS on plain socket", e);
        }
    }

    public void sendDatastream(byte[] outboundDatastream) throws NetworkException {
        if (this.errorException != null) {
            throw new NetworkException("Terminal network connection has gone into error state", this.errorException);
        }
        this.sendDatastream(this.outputStream, outboundDatastream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendDatastream(OutputStream outputStream, byte[] outboundDatastream) throws NetworkException {
        if (outputStream == null) {
            throw new NetworkException("Attempt to send data to a disconnected terminal " + this.terminalId);
        }
        OutputStream outputStream2 = outputStream;
        synchronized (outputStream2) {
            try {
                byte[] header = new byte[]{0, 0, 0, 0, 0};
                byte[] trailer = new byte[]{-1, -17};
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                if (!this.basicTelnet) {
                    baos.write(header);
                }
                baos.write(outboundDatastream);
                baos.write(trailer);
                outputStream.write(baos.toByteArray());
                outputStream.flush();
                this.lastSend = Instant.now();
            }
            catch (IOException e) {
                throw new NetworkException("Unable to write outbound datastream", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendIac(byte[] outboundIac) throws NetworkException {
        OutputStream outputStream = this.outputStream;
        synchronized (outputStream) {
            try {
                this.outputStream.write(outboundIac);
                this.outputStream.flush();
                this.lastSend = Instant.now();
            }
            catch (IOException e) {
                throw new NetworkException("Unable to write outbound iac", e);
            }
        }
    }

    public boolean isTls() {
        return this.ssl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendKeepAlive() {
        if (this.outputStream == null) {
            return;
        }
        if (this.lastSend.plus(10L, ChronoUnit.MINUTES).isAfter(Instant.now())) {
            return;
        }
        OutputStream outputStream = this.outputStream;
        synchronized (outputStream) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                baos.write(-1);
                baos.write(-3);
                baos.write(6);
                this.outputStream.write(baos.toByteArray());
                this.outputStream.flush();
                this.lastSend = Instant.now();
            }
            catch (Exception e) {
                this.logger.error((Object)"Failed to write DO TIMING MARK", (Throwable)e);
            }
        }
    }

    public String getHostPort() {
        return this.host + ":" + Integer.toString(this.port);
    }

    public void setBasicTelnet(boolean basicTelnet) {
        this.basicTelnet = basicTelnet;
    }

    public void switchedSSL(boolean switchedSSL) {
        this.switchedSSL = switchedSSL;
    }

    public boolean isSwitchedSSL() {
        return this.switchedSSL;
    }

    private class KeepAlive
    extends Thread {
        private boolean shutdown = false;

        public KeepAlive() {
            this.setName("3270 keep alive");
        }

        @Override
        public void run() {
            while (!this.shutdown) {
                Network.this.sendKeepAlive();
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private static class TrustAllCerts
    implements X509TrustManager {
        private TrustAllCerts() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

