/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.ipnetwork.spi;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import dev.galasa.ICredentials;
import dev.galasa.ICredentialsUsernamePassword;
import dev.galasa.ICredentialsUsernameToken;
import dev.galasa.ipnetwork.ICommandShell;
import dev.galasa.ipnetwork.SSHAuthFailException;
import dev.galasa.ipnetwork.SSHException;
import dev.galasa.ipnetwork.spi.AnsiEscapeSequences;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SSHClient
implements ICommandShell {
    private final Log logger;
    private KeepAliveThread keepAliveThread;
    private final long defaultTimeout;
    private final String hostname;
    private final int port;
    private final String userid;
    private final String password;
    private JSch sshClient;
    private Session session;
    private Channel channel;
    private long lastCommandTimestamp;
    private boolean logShellResults;
    private boolean removeAnsiEscapeCodes;
    private static final String specialPrompt = "[GalasaPrompt]";
    private String changePromptCommand;

    public SSHClient(String hostname, int port, ICredentials credentials, long defaultTimeout) throws SSHException {
        block5: {
            this.logger = LogFactory.getLog(SSHClient.class);
            this.channel = null;
            this.removeAnsiEscapeCodes = false;
            this.changePromptCommand = "PS1=[GalasaPrompt]";
            this.hostname = hostname;
            this.port = port;
            this.defaultTimeout = defaultTimeout;
            this.sshClient = new JSch();
            this.session = null;
            try {
                if (credentials instanceof ICredentialsUsernamePassword) {
                    ICredentialsUsernamePassword creds = (ICredentialsUsernamePassword)credentials;
                    this.userid = creds.getUsername();
                    this.password = creds.getPassword();
                    break block5;
                }
                if (credentials instanceof ICredentialsUsernameToken) {
                    ICredentialsUsernameToken creds = (ICredentialsUsernameToken)credentials;
                    this.userid = creds.getUsername();
                    this.password = null;
                    this.sshClient.addIdentity(this.userid, creds.getToken(), null, null);
                    break block5;
                }
                throw new SSHException("Unsupported credentials type - " + credentials.getClass().getName());
            }
            catch (SSHException e) {
                throw e;
            }
            catch (JSchException e) {
                throw new SSHException("Problem adding credentials to SSH", e);
            }
        }
    }

    @Override
    public String issueCommand(String command) throws SSHException {
        return this.issueCommand(command, false, this.defaultTimeout);
    }

    @Override
    public String issueCommand(String command, long timeout) throws SSHException {
        return this.issueCommand(command, false, timeout);
    }

    @Override
    public String issueCommand(String command, boolean newShell) throws SSHException {
        return this.issueCommand(command, newShell, this.defaultTimeout);
    }

    @Override
    public synchronized String issueCommand(String command, boolean newShell, long timeout) throws SSHException {
        this.connect();
        JSch jSch = this.sshClient;
        synchronized (jSch) {
            try {
                this.logger.trace((Object)("Issuing '" + command + "'"));
                this.lastCommandTimestamp = System.currentTimeMillis();
                String response = this.retrieveOutput(command, timeout);
                if (this.logShellResults) {
                    this.logger.trace((Object)("Received '" + response));
                }
                this.lastCommandTimestamp = System.currentTimeMillis();
                return response;
            }
            catch (SSHException e) {
                throw e;
            }
            catch (IOException e) {
                throw new SSHException("Error whilst issuing command to ssh '" + command + "'", e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SSHException("Interrupted while trying to retrieve output", e);
            }
            catch (ExecutionException e) {
                throw new SSHException("Execution error while trying to retrieve output", e);
            }
        }
    }

    @Override
    public void setChangePromptCommand(String command) {
        this.changePromptCommand = command + specialPrompt;
    }

    @Override
    public String issueCommandToShell(String command) throws SSHException {
        return this.issueCommandToShell(command, false, this.defaultTimeout);
    }

    @Override
    public String issueCommandToShell(String command, long timeout) throws SSHException {
        return this.issueCommandToShell(command, false, timeout);
    }

    @Override
    public String issueCommandToShell(String command, boolean newShell) throws SSHException {
        return this.issueCommandToShell(command, newShell, this.defaultTimeout);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized String issueCommandToShell(String command, boolean newShell, long timeout) throws SSHException {
        this.connect();
        try {
            if (this.channel == null || this.channel.isClosed() || newShell) {
                if (this.channel != null && !this.channel.isClosed()) {
                    this.logger.trace((Object)"Closing old shell session");
                    this.channel.disconnect();
                }
                this.logger.trace((Object)"Opening new shell session to ssh");
                this.channel = this.session.openChannel("shell");
                ((ChannelShell)this.channel).setPty(true);
                ((ChannelShell)this.channel).setPtyType("ansi", 2048, 24, 0, 0);
                this.channel.connect();
                Thread.sleep(5000L);
            }
            this.lastCommandTimestamp = System.currentTimeMillis();
            this.logger.trace((Object)"Setting special prompt '[GalasaPrompt]'");
            this.retrieveOutputFromShell(this.channel, this.changePromptCommand, timeout);
            Thread.sleep(500L);
            this.lastCommandTimestamp = System.currentTimeMillis();
            String response = this.retrieveOutputFromShell(this.channel, command, timeout);
            this.lastCommandTimestamp = System.currentTimeMillis();
            return response;
        }
        catch (IOException e) {
            throw new SSHException("Error whilst issuing command to ssh '" + command + "'", e);
        }
        catch (JSchException e) {
            throw new SSHException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SSHException("Interrupted while trying to retrieve output", e);
        }
        catch (ExecutionException e) {
            throw new SSHException("Execution error while trying to retrieve output", e);
        }
    }

    @Override
    public void connect() throws SSHException {
        this.connect(5);
    }

    private synchronized void connect(int retry) throws SSHException {
        block13: {
            if (this.session != null && this.session.isConnected()) {
                return;
            }
            try {
                try {
                    this.session = this.sshClient.getSession(this.userid, this.hostname, this.port);
                    this.session.setIdentityRepository(this.sshClient.getIdentityRepository());
                    if (this.password != null) {
                        this.session.setPassword(this.password);
                    }
                    this.session.setConfig("StrictHostKeyChecking", "no");
                    this.session.connect();
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new SSHException("Interrupted trying to authenticate using SSH", e);
                    }
                    this.logger.trace((Object)("SSH Client connected to '" + this.hostname + ":" + this.port));
                    this.keepAliveThread = new KeepAliveThread(this.session);
                    this.keepAliveThread.start();
                }
                catch (Exception e) {
                    if ("Auth fail".equals(e.getMessage())) {
                        throw new SSHAuthFailException(e);
                    }
                    if (retry > 0) {
                        this.logger.trace((Object)"Exception caught during SSH connection, will retry.", (Throwable)e);
                        if (this.session != null && this.session.isConnected()) {
                            this.session.disconnect();
                            this.session = null;
                        }
                        Thread.sleep(5000L);
                        this.connect(retry - 1);
                        break block13;
                    }
                    throw e;
                }
            }
            catch (SSHException e) {
                throw e;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SSHException("Interrupted while trying to retrieve output", e);
            }
            catch (Exception e) {
                throw new SSHException("Unrecognised exception in connection", e);
            }
        }
    }

    @Override
    public void restartShell() throws SSHException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void disconnect() throws SSHException {
        if (this.session == null) {
            return;
        }
        JSch jSch = this.sshClient;
        synchronized (jSch) {
            if (!this.session.isConnected()) {
                this.session = null;
                return;
            }
            this.session.disconnect();
            this.logger.trace((Object)"SSH Client disconnected");
            this.session = null;
        }
    }

    private String retrieveOutput(String command, long timeout) throws IOException, InterruptedException, ExecutionException, SSHException {
        StringBuilder sb = new StringBuilder();
        ChannelExec channel = null;
        try {
            channel = (ChannelExec)this.session.openChannel("exec");
            channel.setPty(true);
            channel.setPtyType("ansi", 2048, 24, 0, 0);
            channel.setInputStream(null);
            channel.setErrStream(null);
            channel.setCommand(command);
            InputStream is = channel.getInputStream();
            InputStream err = channel.getErrStream();
            channel.connect();
            long whenTimeout = Calendar.getInstance().getTimeInMillis() + timeout;
            byte[] tmp = new byte[1024];
            while (true) {
                String data;
                int i;
                if (whenTimeout <= Calendar.getInstance().getTimeInMillis()) {
                    throw new SSHException("Read of command timed out, response so far:-\n" + sb.toString());
                }
                while (is.available() > 0 && (i = is.read(tmp)) >= 0) {
                    data = new String(tmp, 0, i);
                    sb.append(data);
                }
                while (err.available() > 0 && (i = err.read(tmp)) >= 0) {
                    data = new String(tmp, 0, i);
                    sb.append(data);
                }
                if (channel.isClosed()) {
                    if (is.available() > 0 || err.available() > 0) {
                        continue;
                    }
                    break;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
        }
        catch (SSHException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SSHException("Error reading exec output", e);
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
        }
        if (this.removeAnsiEscapeCodes) {
            return new String(this.removeAnsiEscapeCodes(sb.toString().getBytes()));
        }
        return sb.toString();
    }

    private byte[] removeAnsiEscapeCodes(byte[] bytes) throws IOException {
        return AnsiEscapeSequences.stripAnsiEscapeSequences(bytes);
    }

    private String retrieveOutputFromShell(Channel channel, String command, long timeout) throws IOException, InterruptedException, ExecutionException, SSHException {
        Matcher responseMatcher;
        final InputStream in = channel.getInputStream();
        OutputStream os = channel.getOutputStream();
        in.skip(in.available());
        command = command.trim();
        String patternCommand = command.replaceAll(".*[\\r\\n]", "");
        Pattern responsePattern = Pattern.compile("\\Q" + patternCommand + "\\E[\\r\\n]*(.*)\\Q" + specialPrompt + "\\E", 32);
        this.logger.trace((Object)("Submitting command to host '" + this.hostname + "':\n'" + command + "'"));
        os.write((command + " \r\n").getBytes());
        os.flush();
        Thread.sleep(500L);
        StringBuilder responseBuilder = new StringBuilder();
        final byte[] buffer = new byte[5000];
        ExecutorService executor = Executors.newFixedThreadPool(2);
        Callable<Integer> reader = new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return in.read(buffer);
            }
        };
        do {
            Future<Integer> future = executor.submit(reader);
            int read = 0;
            try {
                read = future.get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                executor.shutdown();
                throw new SSHException("Timed out waiting for response from ssh. Response so far: " + responseBuilder);
            }
            responseBuilder.append(new String(buffer, 0, read));
        } while (!(responseMatcher = responsePattern.matcher(responseBuilder.toString())).find());
        executor.shutdown();
        String response = responseMatcher.group(1);
        this.logger.trace((Object)("Retrieved response from host '" + this.hostname + "':\n'" + response + "'"));
        return response;
    }

    @Override
    public void reportResultStrings(boolean report) {
        this.logShellResults = report;
    }

    @Override
    public void setRemoveAnsiEscapeCodes(boolean remoteAnsiEscapeCodes) {
        this.removeAnsiEscapeCodes = remoteAnsiEscapeCodes;
    }

    private class KeepAliveThread
    extends Thread {
        private final Session monitorSession;
        private long idleTimeout = 60000L;

        public KeepAliveThread(Session session) {
            this.monitorSession = session;
            this.setDaemon(true);
            this.setName("GalasaSSHClient timeout thread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SSHClient.this.lastCommandTimestamp = System.currentTimeMillis();
            while (this.monitorSession.isConnected()) {
                SSHClient sSHClient = SSHClient.this;
                synchronized (sSHClient) {
                    long timeout = System.currentTimeMillis() - this.idleTimeout;
                    if (timeout >= SSHClient.this.lastCommandTimestamp) {
                        SSHClient.this.logger.debug((Object)("No command issued after " + this.idleTimeout + " milliseconds, closing SSH session"));
                        this.monitorSession.disconnect();
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (Exception e) {
                    return;
                }
            }
        }
    }
}

