/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.ipnetwork.spi;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.apache.commons.codec.binary.Hex;

public class AnsiEscapeSequences {
    private static final byte ESCAPE = 27;
    private static final byte CONTROL_SEQUENCE_INTRODUCER = 91;
    private static final byte OPERATING_SYSTEM_COMMAND = 93;
    private static final byte BEL = 7;
    private static final byte ST = 92;

    public static byte[] stripAnsiEscapeSequences(byte[] data) throws IOException {
        ByteBuffer in = ByteBuffer.wrap(data);
        ByteBuffer out = ByteBuffer.allocate(data.length);
        while (in.hasRemaining()) {
            byte b = in.get();
            if (b == 27) {
                AnsiEscapeSequences.processEscapeSequence(in, out);
                continue;
            }
            out.put(b);
        }
        byte[] output = new byte[out.position()];
        ((Buffer)out).rewind();
        out.get(output);
        return output;
    }

    private static void processEscapeSequence(ByteBuffer in, ByteBuffer out) throws IOException {
        if (!in.hasRemaining()) {
            throw new IOException("Invalid escape sequence, no type following 0x1B");
        }
        byte b = in.get();
        switch (b) {
            case 91: {
                AnsiEscapeSequences.processControlSequeneceIntroducer(in, out);
                return;
            }
            case 93: {
                AnsiEscapeSequences.processOperatingSystemCommand(in, out);
                return;
            }
        }
        byte[] error = new byte[]{b};
        throw new IOException("Unrecognised escape sequence type 0x" + Hex.encodeHexString((byte[])error));
    }

    private static void processControlSequeneceIntroducer(ByteBuffer in, ByteBuffer out) throws IOException {
        while (in.hasRemaining()) {
            byte b = in.get();
            if (64 > b || b > 126) continue;
            return;
        }
        throw new IOException("ANSI escape control sequence introducer was not terminated by a byte in the range of 0x40 and 0x7E");
    }

    private static void processOperatingSystemCommand(ByteBuffer in, ByteBuffer out) throws IOException {
        while (in.hasRemaining()) {
            byte b = in.get();
            if (b == 7) {
                return;
            }
            if (b != 27) continue;
            if (!in.hasRemaining()) {
                throw new IOException("\"ANSI escape operating system command was not terminated correctly, received ESC but no \\");
            }
            b = in.get();
            if (b != 92) {
                throw new IOException("\"ANSI escape operating system command was not terminated correctly, received ESC but no \\");
            }
            return;
        }
        throw new IOException("ANSI escape operating system command was not terminated BEL or ST");
    }
}

