/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.ipnetwork.internal.ssh.filesystem;

import dev.galasa.ipnetwork.internal.ssh.filesystem.SSHFileSystem;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderMismatchException;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SSHPath
implements Path {
    private final SSHFileSystem fileSystem;
    protected final List<String> nameElements = new ArrayList<String>();
    protected final boolean absolute;

    public SSHPath(SSHFileSystem sshFileSystem, String path) {
        this.fileSystem = sshFileSystem;
        if (path == null) {
            throw new NullPointerException();
        }
        while (path.contains("//")) {
            path = path.replaceAll("\\Q//\\E", "/");
        }
        while (path.contains("\\")) {
            path = path.replaceAll("\\Q\\\\E", "/");
        }
        this.absolute = path.startsWith("/");
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        int firstChar = -1;
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) == '/') {
                if (firstChar == -1) continue;
                this.nameElements.add(path.substring(firstChar, i));
                firstChar = -1;
                continue;
            }
            if (firstChar != -1) continue;
            firstChar = i;
        }
        if (firstChar >= 0) {
            this.nameElements.add(path.substring(firstChar, path.length()));
        }
        for (String part : this.nameElements) {
            if (".".equals(part)) {
                throw new InvalidPathException(path, "Path parts of '.' are not allowed");
            }
            if ("..".equals(part)) {
                throw new InvalidPathException(path, "Path parts of '..' are not allowed");
            }
            if (part.contains("~")) {
                throw new InvalidPathException(path, "Path parts with '~' are not allowed");
            }
            if (!part.contains("=")) continue;
            throw new InvalidPathException(path, "Path parts with '=' are not allowed");
        }
        try {
            this.toUri();
        }
        catch (AssertionError e) {
            throw new AssertionError("Invalid path, would have conversion to URI", (Throwable)((Object)e));
        }
    }

    protected SSHPath(SSHFileSystem fileSystem, boolean absolute, List<String> nameElements, int start, int end) {
        this.fileSystem = fileSystem;
        this.absolute = absolute;
        for (int i = start; i < end; ++i) {
            this.nameElements.add(nameElements.get(i));
        }
    }

    @Override
    public int compareTo(Path other) {
        throw new UnsupportedOperationException("need to write");
    }

    @Override
    public boolean endsWith(Path other) {
        throw new UnsupportedOperationException("need to write");
    }

    @Override
    public boolean endsWith(String other) {
        throw new UnsupportedOperationException("need to write");
    }

    @Override
    public Path getFileName() {
        if (this.nameElements.isEmpty()) {
            return new SSHPath(this.fileSystem, "");
        }
        return new SSHPath(this.fileSystem, false, this.nameElements, this.nameElements.size() - 1, this.nameElements.size());
    }

    @Override
    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public Path getName(int index) {
        return Paths.get(this.nameElements.get(index), new String[0]);
    }

    @Override
    public int getNameCount() {
        return this.nameElements.size();
    }

    @Override
    public Path getParent() {
        if (this.nameElements.isEmpty()) {
            return null;
        }
        return new SSHPath(this.fileSystem, this.absolute, this.nameElements, 0, this.nameElements.size() - 1);
    }

    @Override
    public Path getRoot() {
        throw new UnsupportedOperationException("need to write");
    }

    @Override
    public boolean isAbsolute() {
        return this.absolute;
    }

    @Override
    public Iterator<Path> iterator() {
        ArrayList<SSHPath> paths = new ArrayList<SSHPath>(this.nameElements.size());
        for (String element : this.nameElements) {
            paths.add(new SSHPath(this.fileSystem, element));
        }
        return paths.iterator();
    }

    @Override
    public Path normalize() {
        throw new UnsupportedOperationException("need to write");
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        throw new UnsupportedOperationException("need to write");
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        throw new UnsupportedOperationException("need to write");
    }

    @Override
    public Path relativize(Path other) {
        int i;
        if (this.absolute != other.isAbsolute()) {
            return other;
        }
        if (!(other instanceof SSHPath)) {
            return other;
        }
        SSHPath spother = (SSHPath)other;
        for (i = 0; i < this.nameElements.size(); ++i) {
            if (spother.nameElements.size() <= i) {
                return other;
            }
            if (!this.nameElements.get(i).equals(spother.nameElements.get(i))) break;
        }
        boolean newAbsolute = spother.absolute && i == 0;
        SSHPath path = new SSHPath(this.fileSystem, newAbsolute, spother.nameElements, i, spother.nameElements.size());
        return path;
    }

    @Override
    public Path resolve(Path other) {
        SSHPath o = this.checkPath(other);
        if (o.absolute) {
            return o;
        }
        ArrayList<String> combined = new ArrayList<String>(this.nameElements);
        combined.addAll(o.nameElements);
        return new SSHPath(this.fileSystem, this.absolute, combined, 0, combined.size());
    }

    @Override
    public Path resolve(String other) {
        return this.resolve(new SSHPath(this.fileSystem, other));
    }

    private SSHPath checkPath(Path path) {
        if (path == null) {
            throw new NullPointerException();
        }
        if (!(path instanceof SSHPath)) {
            throw new ProviderMismatchException();
        }
        return (SSHPath)path;
    }

    @Override
    public Path resolveSibling(Path other) {
        throw new UnsupportedOperationException("need to write");
    }

    @Override
    public Path resolveSibling(String other) {
        throw new UnsupportedOperationException("need to write");
    }

    @Override
    public boolean startsWith(Path other) {
        throw new UnsupportedOperationException("need to write");
    }

    @Override
    public boolean startsWith(String other) {
        throw new UnsupportedOperationException("need to write");
    }

    @Override
    public Path subpath(int beginIndex, int endIndex) {
        throw new UnsupportedOperationException("need to write");
    }

    @Override
    public Path toAbsolutePath() {
        if (this.absolute) {
            return this;
        }
        return new SSHPath(this.fileSystem, true, this.nameElements, 0, this.nameElements.size());
    }

    @Override
    public File toFile() {
        throw new UnsupportedOperationException("Unable to translate to a java.ioFile");
    }

    @Override
    public Path toRealPath(LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException("need to write");
    }

    @Override
    public URI toUri() {
        try {
            return new URI(this.fileSystem.provider().getScheme() + ":" + this.toAbsolutePath().toString());
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public String toString() {
        if (this.absolute && this.nameElements.isEmpty()) {
            return "/";
        }
        StringBuilder sb = new StringBuilder();
        boolean prefixSeperator = this.absolute;
        for (String element : this.nameElements) {
            if (prefixSeperator) {
                sb.append("/");
            }
            sb.append(element);
            prefixSeperator = true;
        }
        return sb.toString();
    }
}

