/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.ipnetwork.internal.ssh.filesystem;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import dev.galasa.ICredentials;
import dev.galasa.ICredentialsUsernamePassword;
import dev.galasa.ICredentialsUsernameToken;
import dev.galasa.ipnetwork.SSHException;
import dev.galasa.ipnetwork.internal.ssh.filesystem.SSHFileStore;
import dev.galasa.ipnetwork.internal.ssh.filesystem.SSHFileSystemProvider;
import dev.galasa.ipnetwork.internal.ssh.filesystem.SSHPath;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SSHFileSystem
extends FileSystem {
    private final Log logger;
    private final String hostname;
    private final int port;
    private final String userid;
    private final String password;
    private JSch sshClient;
    private Session session;
    private final SSHFileStore fileStore;
    private final SSHFileSystemProvider fileSystemProvider;

    public SSHFileSystem(String hostname, int port, ICredentials credentials) throws SSHException {
        block5: {
            this.logger = LogFactory.getLog(SSHFileSystemProvider.class);
            this.hostname = hostname;
            this.port = port;
            this.fileStore = new SSHFileStore("sshfilestore-" + hostname);
            this.fileSystemProvider = new SSHFileSystemProvider(this);
            this.sshClient = new JSch();
            this.session = null;
            try {
                if (credentials instanceof ICredentialsUsernamePassword) {
                    ICredentialsUsernamePassword creds = (ICredentialsUsernamePassword)credentials;
                    this.userid = creds.getUsername();
                    this.password = creds.getPassword();
                    break block5;
                }
                if (credentials instanceof ICredentialsUsernameToken) {
                    ICredentialsUsernameToken creds = (ICredentialsUsernameToken)credentials;
                    this.userid = creds.getUsername();
                    this.password = null;
                    this.sshClient.addIdentity(this.userid, creds.getToken(), null, null);
                    break block5;
                }
                throw new SSHException("Unsupported credentials type - " + credentials.getClass().getName());
            }
            catch (SSHException e) {
                throw e;
            }
            catch (JSchException e) {
                throw new SSHException("Problem adding credentials to SSH", e);
            }
        }
    }

    public void connect() throws SSHException {
        this.connect(5);
    }

    private synchronized void connect(int retry) throws SSHException {
        block12: {
            if (this.session != null && this.session.isConnected()) {
                return;
            }
            try {
                try {
                    this.session = this.sshClient.getSession(this.userid, this.hostname, this.port);
                    this.session.setIdentityRepository(this.sshClient.getIdentityRepository());
                    if (this.password != null) {
                        this.session.setPassword(this.password);
                    }
                    this.session.setConfig("StrictHostKeyChecking", "no");
                    this.session.connect();
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new SSHException("Interrupted trying to authenticate using SSH", e);
                    }
                    this.logger.trace((Object)("SSH Client connected to '" + this.hostname + ":" + this.port));
                }
                catch (Exception e) {
                    if (retry > 0) {
                        this.logger.trace((Object)"Exception caught during SSH connection, will retry.", (Throwable)e);
                        if (this.session != null && this.session.isConnected()) {
                            this.session.disconnect();
                            this.session = null;
                        }
                        Thread.sleep(5000L);
                        this.connect(retry - 1);
                        break block12;
                    }
                    throw e;
                }
            }
            catch (SSHException e) {
                throw e;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SSHException("Interrupted while trying to retrieve output", e);
            }
            catch (Exception e) {
                throw new SSHException("Unrecognised exception in connection", e);
            }
        }
    }

    protected ChannelSftp getFileChannel() throws SSHException {
        this.connect();
        try {
            Channel channel = this.session.openChannel("sftp");
            channel.connect();
            return (ChannelSftp)channel;
        }
        catch (Exception e) {
            throw new SSHException("Unable to open a sftp channel to the server", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disconnect() throws SSHException {
        if (this.session == null) {
            return;
        }
        JSch jSch = this.sshClient;
        synchronized (jSch) {
            if (!this.session.isConnected()) {
                this.session = null;
                return;
            }
            this.session.disconnect();
            this.logger.trace((Object)"SSH Client disconnected");
            this.session = null;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.disconnect();
        }
        catch (SSHException e) {
            throw new IOException("Problem disconnecting the SSH FileSystem");
        }
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        ArrayList<FileStore> fileStores = new ArrayList<FileStore>();
        fileStores.add(this.fileStore);
        return fileStores;
    }

    @Override
    public Path getPath(String first, String ... more) {
        StringBuilder sb = new StringBuilder();
        if (first != null) {
            sb.append(first);
        }
        for (String m : more) {
            if (m == null) continue;
            if (sb.length() > 0) {
                sb.append("/");
            }
            sb.append(m);
        }
        return new SSHPath(this, sb.toString());
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndInput) {
        String expr;
        int pos = syntaxAndInput.indexOf(58);
        if (pos <= 0 || pos >= syntaxAndInput.length() - 1) {
            throw new IllegalArgumentException();
        }
        String syntax = syntaxAndInput.substring(0, pos);
        String input = syntaxAndInput.substring(pos + 1);
        if ("glob".equals(syntax)) {
            expr = SSHFileSystem.createRegexFromGlob(input);
        } else if ("regex".equals(syntax)) {
            expr = input;
        } else {
            throw new UnsupportedOperationException("Syntax '" + syntax + "' not recognized");
        }
        final Pattern pattern = Pattern.compile(expr);
        return new PathMatcher(){

            @Override
            public boolean matches(Path path) {
                return pattern.matcher(path.toString()).matches();
            }

            public String toString() {
                return pattern.toString();
            }
        };
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        ArrayList<Path> roots = new ArrayList<Path>();
        roots.add(new SSHPath(this, "/"));
        return roots;
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        return null;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public WatchService newWatchService() throws IOException {
        throw new UnsupportedOperationException("Watch Service is not available with this FileSystem");
    }

    @Override
    public FileSystemProvider provider() {
        return this.fileSystemProvider;
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        throw new UnsupportedOperationException("need to write");
    }

    public static String createRegexFromGlob(String glob) {
        StringBuilder sb = new StringBuilder();
        sb.append("^");
        block6: for (int i = 0; i < glob.length(); ++i) {
            char c = glob.charAt(i);
            switch (c) {
                case '*': {
                    sb.append(".*");
                    continue block6;
                }
                case '?': {
                    sb.append('.');
                    continue block6;
                }
                case '.': {
                    sb.append("\\.");
                    continue block6;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        sb.append('$');
        return sb.toString();
    }
}

