/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.ipnetwork.internal.ssh.filesystem;

import com.jcraft.jsch.ChannelSftp;
import dev.galasa.ipnetwork.internal.ssh.filesystem.SSHFileSystem;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

public class SSHDirectoryStream
implements DirectoryStream<Path> {
    private final ArrayList<Path> paths = new ArrayList();

    public SSHDirectoryStream(Path path, SSHFileSystem fileSystem, DirectoryStream.Filter<? super Path> filter) throws IOException {
        path = path.toAbsolutePath();
        ChannelSftp channel = null;
        try {
            channel = fileSystem.getFileChannel();
            Vector ls = channel.ls(path.toString());
            for (Object entry : ls) {
                Path child;
                ChannelSftp.LsEntry lsEntry;
                String fileName;
                if (!(entry instanceof ChannelSftp.LsEntry) || ".".equals(fileName = (lsEntry = (ChannelSftp.LsEntry)entry).getFilename()) || "..".equals(fileName) || !filter.accept(child = path.resolve(fileName))) continue;
                this.paths.add(child);
            }
        }
        catch (Exception e) {
            throw new IOException("Unable to get directory listing", e);
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public Iterator<Path> iterator() {
        return this.paths.iterator();
    }
}

