/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.ipnetwork.internal.ssh.filesystem;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import dev.galasa.ipnetwork.SSHException;
import dev.galasa.ipnetwork.internal.ssh.filesystem.SSHFileSystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Set;

public class SSHByteChannel
implements SeekableByteChannel {
    private long size = 0L;
    private long position = 0L;
    private final SSHFileSystem fileSystem;
    private final Path path;
    private final ChannelSftp channel;
    private final InputStream inputStream;
    private final OutputStream outputStream;

    public SSHByteChannel(Path path, Set<? extends OpenOption> options, SSHFileSystem fileSystem) throws SSHException {
        this.fileSystem = fileSystem;
        this.path = path.toAbsolutePath();
        this.channel = this.fileSystem.getFileChannel();
        boolean write = options.contains(StandardOpenOption.WRITE);
        try {
            if (write) {
                this.inputStream = null;
                this.outputStream = this.channel.put(this.path.toString());
            } else {
                this.outputStream = null;
                SftpATTRS attrs = this.channel.lstat(this.path.toString());
                this.size = attrs.getSize();
                this.inputStream = this.channel.get(this.path.toString());
            }
        }
        catch (SftpException e) {
            throw new SSHException("Unable to open SSH file " + this.path, e);
        }
    }

    @Override
    public boolean isOpen() {
        return this.channel.isConnected();
    }

    @Override
    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
        }
        if (this.outputStream != null) {
            this.outputStream.close();
        }
        this.channel.disconnect();
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        byte[] data = new byte[dst.remaining()];
        int len = this.inputStream.read(data);
        if (len < 0) {
            return len;
        }
        dst.put(data, 0, len);
        this.position += (long)len;
        return len;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        int len = src.remaining();
        byte[] data = new byte[len];
        src.get(data, 0, len);
        this.outputStream.write(data, 0, len);
        this.size += (long)len;
        this.position += (long)len;
        return len;
    }

    @Override
    public long position() throws IOException {
        return this.position;
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        throw new UnsupportedOperationException("need to write");
    }

    @Override
    public long size() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        return this.size;
    }

    @Override
    public SeekableByteChannel truncate(long size) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        throw new UnsupportedOperationException("need to write");
    }
}

