/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.ipnetwork.internal;

import dev.galasa.framework.spi.IConfigurationPropertyStoreService;
import dev.galasa.framework.spi.IDynamicStatusStoreService;
import dev.galasa.framework.spi.IFramework;
import dev.galasa.framework.spi.IResourceManagement;
import dev.galasa.ipnetwork.internal.IpNetworkResourceManagement;
import dev.galasa.ipnetwork.internal.IpPortImpl;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PortResourceMonitor
implements Runnable {
    private final IFramework framework;
    private final IResourceManagement resourceManagement;
    private final IDynamicStatusStoreService dss;
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Pattern portRunPattern = Pattern.compile("^port\\.run\\.(\\w+)\\.host\\.(\\w+)\\.port\\.(\\d+)$");

    protected PortResourceMonitor(IFramework framework, IResourceManagement resourceManagement, IDynamicStatusStoreService dss, IpNetworkResourceManagement ipNetworkResourceManagement, IConfigurationPropertyStoreService cps) {
        this.framework = framework;
        this.resourceManagement = resourceManagement;
        this.dss = dss;
        this.logger.info((Object)"IP Network Port resource monitor initialised");
    }

    @Override
    public void run() {
        this.logger.info((Object)"Starting Run Port search");
        try {
            Set activeRunNames = this.framework.getFrameworkRuns().getActiveRunNames();
            Map portRuns = this.dss.getPrefix("port.run.");
            for (String key : portRuns.keySet()) {
                String runName;
                Matcher matcher = this.portRunPattern.matcher(key);
                if (!matcher.find() || activeRunNames.contains(runName = matcher.group(1))) continue;
                String hostId = matcher.group(2);
                String port = matcher.group(3);
                this.logger.info((Object)("Discarding port " + port + " on host " + hostId + " as run " + runName + " has gone"));
                try {
                    IpPortImpl.deleteDss(runName, hostId, port, this.dss);
                }
                catch (Exception e) {
                    this.logger.error((Object)("Failed to discard port " + port + " on host " + hostId + " as run " + runName));
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Failure during port active runs scan", (Throwable)e);
        }
        this.resourceManagement.resourceManagementRunSuccessful();
        this.logger.info((Object)"Finished Run Port search");
    }

    public void runFinishedOrDeleted(String runName) {
        try {
            Map portRuns = this.dss.getPrefix("port.run." + runName + ".");
            for (String key : portRuns.keySet()) {
                Matcher matcher = this.portRunPattern.matcher(key);
                if (!matcher.find()) continue;
                String hostId = matcher.group(2);
                String port = matcher.group(3);
                this.logger.info((Object)("Discarding port " + port + " on host " + hostId + " as run " + runName + " has gone"));
                IpPortImpl.deleteDss(runName, hostId, port, this.dss);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Failed to delete ports for run " + runName));
        }
    }
}

