/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.ipnetwork.internal;

import dev.galasa.framework.spi.IConfigurationPropertyStoreService;
import dev.galasa.framework.spi.IDynamicStatusStoreService;
import dev.galasa.framework.spi.IFramework;
import dev.galasa.framework.spi.IResourceManagement;
import dev.galasa.framework.spi.IResourceManagementProvider;
import dev.galasa.framework.spi.ResourceManagerException;
import dev.galasa.ipnetwork.internal.PortResourceMonitor;
import java.util.concurrent.TimeUnit;
import org.osgi.service.component.annotations.Component;

@Component(service={IResourceManagementProvider.class})
public class IpNetworkResourceManagement
implements IResourceManagementProvider {
    private IFramework framework;
    private IResourceManagement resourceManagement;
    private IDynamicStatusStoreService dss;
    private IConfigurationPropertyStoreService cps;
    private PortResourceMonitor portResourceMonitor;

    public boolean initialise(IFramework framework, IResourceManagement resourceManagement) throws ResourceManagerException {
        this.framework = framework;
        this.resourceManagement = resourceManagement;
        try {
            this.dss = this.framework.getDynamicStatusStoreService("ipnetwork");
            this.cps = this.framework.getConfigurationPropertyService("ipnetwork");
        }
        catch (Exception e) {
            throw new ResourceManagerException("Unable to initialise IP Network resource monitor", (Throwable)e);
        }
        this.portResourceMonitor = new PortResourceMonitor(framework, resourceManagement, this.dss, this, this.cps);
        return true;
    }

    public void start() {
        this.resourceManagement.getScheduledExecutorService().scheduleWithFixedDelay(this.portResourceMonitor, this.framework.getRandom().nextInt(20), 20L, TimeUnit.SECONDS);
    }

    public void shutdown() {
    }

    public void runFinishedOrDeleted(String runName) {
        this.portResourceMonitor.runFinishedOrDeleted(runName);
    }
}

