/*
 * Decompiled with CFR 0.152.
 */
package pl.defunkt;

import com.sun.management.OperatingSystemMXBean;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.RuntimeMXBean;
import javax.management.MBeanServerConnection;

public class CpuHeapUsage {
    private OperatingSystemMXBean peOperatingSystemMXBean;
    private java.lang.management.OperatingSystemMXBean operatingSystemMXBean;
    private RuntimeMXBean runtimeMXBean;
    private MemoryMXBean memoryMXBean;
    private long previousJvmProcessCpuTime = 0L;
    private long previousJvmUptime = 0L;

    public CpuHeapUsage(MBeanServerConnection mBeanServerConnection) throws IOException {
        this.setupProxies(mBeanServerConnection);
    }

    public void setupProxies(MBeanServerConnection mBeanServerConnection) throws IOException {
        this.peOperatingSystemMXBean = ManagementFactory.newPlatformMXBeanProxy(mBeanServerConnection, "java.lang:type=OperatingSystem", OperatingSystemMXBean.class);
        this.operatingSystemMXBean = ManagementFactory.newPlatformMXBeanProxy(mBeanServerConnection, "java.lang:type=OperatingSystem", java.lang.management.OperatingSystemMXBean.class);
        this.runtimeMXBean = ManagementFactory.newPlatformMXBeanProxy(mBeanServerConnection, "java.lang:type=Runtime", RuntimeMXBean.class);
        this.memoryMXBean = ManagementFactory.newPlatformMXBeanProxy(mBeanServerConnection, "java.lang:type=Memory", MemoryMXBean.class);
    }

    public float getCpuUsed() {
        long l = this.peOperatingSystemMXBean.getProcessCpuTime() - this.previousJvmProcessCpuTime;
        long l2 = this.runtimeMXBean.getUptime() - this.previousJvmUptime;
        long l3 = l2 * (long)this.operatingSystemMXBean.getAvailableProcessors();
        float f = (float)l / ((float)l3 * 10000.0f);
        this.previousJvmProcessCpuTime = this.peOperatingSystemMXBean.getProcessCpuTime();
        this.previousJvmUptime = this.runtimeMXBean.getUptime();
        return f;
    }

    public long getHeapInit() {
        return this.memoryMXBean.getHeapMemoryUsage().getInit();
    }

    public long getHeapCommitted() {
        return this.memoryMXBean.getHeapMemoryUsage().getCommitted();
    }

    public long getHeapUsed() {
        return this.memoryMXBean.getHeapMemoryUsage().getUsed();
    }

    public long getHeapMax() {
        return this.memoryMXBean.getHeapMemoryUsage().getMax();
    }
}

