/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.llog.impl.multi;

import de.linusdev.llog.LLog;
import de.linusdev.llog.base.LogLevel;
import de.linusdev.llog.base.LogSource;
import de.linusdev.llog.base.Logger;
import de.linusdev.llog.base.data.LogData;
import de.linusdev.llog.replacer.LLogStringReplacer;
import de.linusdev.lutils.llist.LLinkedList;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiLoggerImpl
implements Logger {
    public static final String SUB_LOGGER_KEY_PREFIX = "sub-logger-";
    @NotNull
    private final LLinkedList<Logger> loggers = new LLinkedList();

    public static void adjustReplacer(@NotNull LLogStringReplacer replacer) {
    }

    @NotNull
    public static Logger create(@NotNull Properties properties) {
        MultiLoggerImpl multi = new MultiLoggerImpl();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (!(entry.getKey() instanceof String) || !((String)entry.getKey()).startsWith(SUB_LOGGER_KEY_PREFIX)) continue;
            String subLoggerPropertiesLocation = (String)entry.getValue();
            try {
                @Nullable InputStream propertiesFileStream = LLog.class.getClassLoader().getResourceAsStream(subLoggerPropertiesLocation);
                try {
                    @NotNull Properties props = new Properties();
                    if (propertiesFileStream != null) {
                        props.load(propertiesFileStream);
                    }
                    String clazz = (String)props.get("logger");
                    Logger logger = LLog.createLogger(clazz, props, new LLogStringReplacer());
                    System.out.println("MultiLogger: started a logger: " + logger.getClass().getSimpleName() + ".");
                    multi.addLogger(logger);
                }
                finally {
                    if (propertiesFileStream == null) continue;
                    propertiesFileStream.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("MultiLogger: Cannot start logger with properties '" + subLoggerPropertiesLocation + "': " + e.getClass().getSimpleName() + ": " + e.getMessage() + ".");
            }
        }
        return multi;
    }

    public void addLogger(@NotNull Logger logger) {
        this.loggers.add((Object)logger);
    }

    public void removeLogger(@NotNull Logger logger) {
        this.loggers.remove((Object)logger);
    }

    @Override
    public void log(@NotNull LogLevel logLevel, @NotNull LogSource source, @NotNull LogData data) {
        for (Logger logger : this.loggers) {
            logger.log(logLevel, source, data);
        }
    }

    @Override
    public boolean flush() {
        boolean ret = false;
        for (Logger logger : this.loggers) {
            ret = ret || logger.flush();
        }
        return ret;
    }

    @Override
    public boolean isFlushable() {
        boolean ret = false;
        for (Logger logger : this.loggers) {
            ret = ret || logger.isFlushable();
        }
        return ret;
    }

    @Override
    public void setMinimumLogLevel(int level) {
        for (Logger logger : this.loggers) {
            logger.setMinimumLogLevel(level);
        }
    }

    @Override
    public void shutdown() throws Exception {
        for (Logger logger : this.loggers) {
            logger.shutdown();
        }
    }
}

