/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.llog.base.impl;

import de.linusdev.llog.base.LogInstance;
import de.linusdev.llog.base.Logger;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StandardLogInstance
implements LogInstance {
    @NotNull
    private final Logger logger;
    @NotNull
    private final String name;
    @Nullable
    private final Map<String, String> information;

    public StandardLogInstance(@NotNull Logger logger, @NotNull String name, @Nullable Map<String, String> information) {
        this.logger = logger;
        this.name = name;
        this.information = information;
    }

    public StandardLogInstance(@NotNull Logger logger, @NotNull Class<?> source) {
        this.logger = logger;
        this.name = source.getSimpleName();
        this.information = new HashMap<String, String>();
        this.information.put("canonical class name", source.getCanonicalName());
    }

    @Override
    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public Map<String, String> getAdditionalInformation() {
        return this.information;
    }
}

