/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.llog.base.data;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface ContentTypeAttribute {
    @NotNull
    public static final String CHARSET_ATTRIBUTE_KEY = "charset";

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static ContentTypeAttribute of(@NotNull String key, @NotNull String value) {
        return new Impl(key, value);
    }

    @NotNull
    public String getKey();

    @NotNull
    public String getValue();

    public static class Impl
    implements ContentTypeAttribute {
        @NotNull
        private final String key;
        @NotNull
        private final String value;

        public Impl(@NotNull String key, @NotNull String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        @NotNull
        public String getKey() {
            return this.key;
        }

        @Override
        @NotNull
        public String getValue() {
            return this.value;
        }
    }
}

