/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.llog.base.data;

import de.linusdev.llog.base.data.ContentTypeAttribute;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public interface ContentType {
    @NotNull
    public String getTopLevel();

    @NotNull
    public String getSubLevel();

    @NotNull
    public ContentTypeAttribute[] getAttributes();

    @NotNull
    default public String generateFormattedString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTopLevel()).append("/").append(this.getSubLevel());
        for (ContentTypeAttribute attribute : this.getAttributes()) {
            sb.append(" ").append(attribute.getKey()).append("=").append(attribute.getValue());
        }
        return sb.toString();
    }

    default public boolean is(@NotNull ContentType other) {
        return Objects.equals(this.getTopLevel(), other.getTopLevel()) && Objects.equals(this.getSubLevel(), other.getSubLevel());
    }
}

