/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.llog.base;

import de.linusdev.llog.base.LogLevel;
import de.linusdev.llog.base.LogSource;
import de.linusdev.llog.base.Logger;
import de.linusdev.llog.base.data.LogData;
import de.linusdev.llog.base.impl.StandardLogLevel;
import de.linusdev.llog.base.impl.data.LogSOData;
import de.linusdev.llog.base.impl.data.TextLogData;
import de.linusdev.llog.base.impl.data.ThrowableLogData;
import me.linusdev.data.so.SOData;
import org.jetbrains.annotations.NotNull;

public interface LogInstance
extends LogSource {
    default public void log(@NotNull LogLevel logLevel, @NotNull LogData data) {
        this.getLogger().log(logLevel, (LogSource)this, data);
    }

    default public void log(@NotNull LogLevel logLevel, @NotNull String text) {
        this.log(logLevel, new TextLogData(text));
    }

    default public void log(@NotNull LogLevel logLevel, @NotNull SOData data) {
        this.log(logLevel, new LogSOData(data));
    }

    default public void logError(@NotNull String text) {
        this.log((LogLevel)StandardLogLevel.ERROR, text);
    }

    default public void logWarning(@NotNull String text) {
        this.log((LogLevel)StandardLogLevel.WARNING, text);
    }

    default public void logInfo(@NotNull String text) {
        this.log((LogLevel)StandardLogLevel.INFO, text);
    }

    default public void logDebug(@NotNull String text) {
        this.log((LogLevel)StandardLogLevel.DEBUG, text);
    }

    default public void logDebugLow(@NotNull String text) {
        this.log((LogLevel)StandardLogLevel.DEBUG_LOW, text);
    }

    default public void logThrowable(@NotNull Throwable throwable) {
        this.log((LogLevel)StandardLogLevel.ERROR, new ThrowableLogData(throwable));
    }

    @NotNull
    public Logger getLogger();

    default public boolean flush() {
        return this.getLogger().flush();
    }

    default public boolean isFlushable() {
        return this.getLogger().isFlushable();
    }
}

