/*
 * Decompiled with CFR 0.152.
 */
package de.lolhens.http4s.jwt;

import cats.MonadError;
import cats.syntax.package;
import de.lolhens.http4s.jwt.Jwt;
import de.lolhens.http4s.jwt.Jwt$;
import de.lolhens.http4s.jwt.JwtCodec$;
import de.lolhens.http4s.jwt.JwtValidationOptions;
import de.lolhens.http4s.jwt.JwtVerifier$;
import java.io.Serializable;
import java.security.PublicKey;
import javax.crypto.SecretKey;
import pdi.jwt.JwtAlgorithm;
import pdi.jwt.JwtClaim;
import pdi.jwt.JwtHeader;
import pdi.jwt.JwtUtils$;
import pdi.jwt.algorithms.JwtAsymmetricAlgorithm;
import pdi.jwt.algorithms.JwtECDSAAlgorithm;
import pdi.jwt.algorithms.JwtHmacAlgorithm;
import pdi.jwt.algorithms.JwtRSAAlgorithm;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public abstract class JwtVerifier<F, Algorithm extends JwtAlgorithm, A> {
    private final Seq algorithms;
    private final MonadError<F, Throwable> F;

    public static Seq<JwtAlgorithm> allAlgorithms() {
        return JwtVerifier$.MODULE$.allAlgorithms();
    }

    public static <F> JwtVerifier<F, JwtAlgorithm, BoxedUnit> apply(String string, Seq<JwtAlgorithm> seq, MonadError<F, Throwable> monadError) {
        return JwtVerifier$.MODULE$.apply(string, seq, monadError);
    }

    public static <F> JwtVerifier<F, JwtAsymmetricAlgorithm, BoxedUnit> asymmetric(PublicKey publicKey, MonadError<F, Throwable> monadError) {
        return JwtVerifier$.MODULE$.asymmetric(publicKey, monadError);
    }

    public static <F, Algorithm extends JwtAsymmetricAlgorithm> JwtVerifier<F, Algorithm, BoxedUnit> asymmetric(PublicKey publicKey, Seq<Algorithm> seq, MonadError<F, Throwable> monadError) {
        return JwtVerifier$.MODULE$.asymmetric(publicKey, seq, monadError);
    }

    public static <F> JwtVerifier<F, JwtECDSAAlgorithm, BoxedUnit> ecdsa(PublicKey publicKey, Seq<JwtECDSAAlgorithm> seq, MonadError<F, Throwable> monadError) {
        return JwtVerifier$.MODULE$.ecdsa(publicKey, seq, monadError);
    }

    public static <F> JwtVerifier<F, JwtHmacAlgorithm, BoxedUnit> hmac(SecretKey secretKey, Seq<JwtHmacAlgorithm> seq, MonadError<F, Throwable> monadError) {
        return JwtVerifier$.MODULE$.hmac(secretKey, seq, monadError);
    }

    public static <F> JwtVerifier<F, JwtRSAAlgorithm, BoxedUnit> rsa(PublicKey publicKey, Seq<JwtRSAAlgorithm> seq, MonadError<F, Throwable> monadError) {
        return JwtVerifier$.MODULE$.rsa(publicKey, seq, monadError);
    }

    public static <F> Seq<JwtAlgorithm> apply$default$2() {
        return JwtVerifier$.MODULE$.apply$default$2();
    }

    public static <F> Seq<JwtECDSAAlgorithm> ecdsa$default$2() {
        return JwtVerifier$.MODULE$.ecdsa$default$2();
    }

    public static <F> Seq<JwtHmacAlgorithm> hmac$default$2() {
        return JwtVerifier$.MODULE$.hmac$default$2();
    }

    public static <F> Seq<JwtRSAAlgorithm> rsa$default$2() {
        return JwtVerifier$.MODULE$.rsa$default$2();
    }

    public JwtVerifier(Seq<Algorithm> algorithms, MonadError<F, Throwable> F) {
        this.algorithms = algorithms;
        this.F = F;
    }

    public Seq<Algorithm> algorithms() {
        return this.algorithms;
    }

    public final F decode(String token, JwtValidationOptions options) {
        ClassTag Jwt$u005BAlgorithm$u005D = (ClassTag)Predef$.MODULE$.implicitly((Object)ClassTag$.MODULE$.apply(Jwt.class));
        return (F)package.functor$.MODULE$.toFunctorOps(JwtCodec$.MODULE$.decodeAllAndVerify(token, options.jwtOptions(), (Function1<Jwt<JwtAlgorithm>, Object>)(Function1 & Serializable)x$1 -> {
            Jwt jwt;
            Jwt jwt2;
            Option option;
            Jwt jwt3 = x$1;
            if (jwt3 != null && !(option = Jwt$u005BAlgorithm$u005D.unapply((Object)jwt3)).isEmpty() && (jwt2 = (jwt = (Jwt)option.get())) != null) {
                Jwt jwt4 = Jwt$.MODULE$.unapply(jwt2);
                JwtHeader jwtHeader = jwt4._1();
                JwtClaim jwtClaim = jwt4._2();
                byte[] byArray = jwt4._3();
                byte[] byArray2 = jwt4._4();
                JwtHeader head = jwtHeader;
                JwtClaim claim = jwtClaim;
                Jwt jwt5 = jwt2;
                if (head.algorithm().forall((Function1 & Serializable)elem -> this.algorithms().contains(elem))) {
                    options.validateRequired(claim);
                    return this.verified(jwt5);
                }
            }
            return this.F.pure((Object)None$.MODULE$);
        }, this.F), this.F).map((Function1 & Serializable)_$2 -> _$2.map((Function1 & Serializable)x$1 -> {
            Option option;
            Jwt jwt;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null && (jwt = (Jwt)tuple2._1()) != null && !(option = Jwt$u005BAlgorithm$u005D.unapply((Object)jwt)).isEmpty()) {
                Jwt jwt2;
                Jwt jwt3 = jwt2 = (Jwt)option.get();
                Option verified = (Option)tuple2._2();
                return Tuple2$.MODULE$.apply((Object)jwt3, (Object)verified);
            }
            throw new MatchError((Object)tuple2);
        }));
    }

    public abstract F verified(Jwt<Algorithm> var1);

    public final boolean verify(Jwt<Algorithm> jwt, String key) {
        return JwtUtils$.MODULE$.verify(jwt.data(), jwt.signature(), key, (JwtAlgorithm)jwt.algorithm().get());
    }

    public final boolean verifyHmac(Jwt<JwtHmacAlgorithm> jwt, SecretKey key) {
        return JwtUtils$.MODULE$.verify(jwt.data(), jwt.signature(), key, (JwtHmacAlgorithm)jwt.algorithm().get());
    }

    public final boolean verifyAsymmetric(Jwt<JwtAsymmetricAlgorithm> jwt, PublicKey key) {
        return JwtUtils$.MODULE$.verify(jwt.data(), jwt.signature(), key, (JwtAsymmetricAlgorithm)jwt.algorithm().get());
    }
}

