/*
 * Decompiled with CFR 0.152.
 */
package de.lolhens.http4s.jwt;

import cats.MonadError;
import de.lolhens.http4s.jwt.Jwt;
import de.lolhens.http4s.jwt.JwtVerifier;
import java.io.Serializable;
import java.security.PublicKey;
import javax.crypto.SecretKey;
import pdi.jwt.JwtAlgorithm;
import pdi.jwt.JwtAlgorithm$;
import pdi.jwt.algorithms.JwtAsymmetricAlgorithm;
import pdi.jwt.algorithms.JwtECDSAAlgorithm;
import pdi.jwt.algorithms.JwtHmacAlgorithm;
import pdi.jwt.algorithms.JwtRSAAlgorithm;
import scala.None$;
import scala.Some$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;

public final class JwtVerifier$
implements Serializable {
    private static final Seq allAlgorithms;
    public static final JwtVerifier$ MODULE$;

    private JwtVerifier$() {
    }

    static {
        MODULE$ = new JwtVerifier$();
        allAlgorithms = (Seq)((IterableOps)JwtAlgorithm$.MODULE$.allHmac().$plus$plus((IterableOnce)JwtAlgorithm$.MODULE$.allRSA())).$plus$plus((IterableOnce)JwtAlgorithm$.MODULE$.allECDSA());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JwtVerifier$.class);
    }

    public Seq<JwtAlgorithm> allAlgorithms() {
        return allAlgorithms;
    }

    public <F> JwtVerifier<F, JwtAlgorithm, BoxedUnit> apply(String key, Seq<JwtAlgorithm> algorithms, MonadError<F, Throwable> F) {
        return new JwtVerifier<F, JwtAlgorithm, BoxedUnit>(key, algorithms, F){
            private final String key$2;
            private final MonadError F$2;
            {
                this.key$2 = key$1;
                this.F$2 = F$1;
                super(algorithms$1, F$1);
            }

            public Object verified(Jwt jwt) {
                return this.F$2.pure(this.verify(jwt, this.key$2) ? Some$.MODULE$.apply((Object)BoxedUnit.UNIT) : None$.MODULE$);
            }
        };
    }

    public <F> Seq<JwtAlgorithm> apply$default$2() {
        return this.allAlgorithms();
    }

    public <F> JwtVerifier<F, JwtHmacAlgorithm, BoxedUnit> hmac(SecretKey key, Seq<JwtHmacAlgorithm> algorithms, MonadError<F, Throwable> F) {
        return new JwtVerifier<F, JwtHmacAlgorithm, BoxedUnit>(key, algorithms, F){
            private final SecretKey key$4;
            private final MonadError F$4;
            {
                this.key$4 = key$3;
                this.F$4 = F$3;
                super(algorithms$2, F$3);
            }

            public Object verified(Jwt jwt) {
                return this.F$4.pure(this.verifyHmac(jwt, this.key$4) ? Some$.MODULE$.apply((Object)BoxedUnit.UNIT) : None$.MODULE$);
            }
        };
    }

    public <F> Seq<JwtHmacAlgorithm> hmac$default$2() {
        return JwtAlgorithm$.MODULE$.allHmac();
    }

    public <F, Algorithm extends JwtAsymmetricAlgorithm> JwtVerifier<F, Algorithm, BoxedUnit> asymmetric(PublicKey key, Seq<Algorithm> algorithms, MonadError<F, Throwable> F) {
        return new JwtVerifier<F, Algorithm, BoxedUnit>(key, algorithms, F){
            private final PublicKey key$6;
            private final MonadError F$6;
            {
                this.key$6 = key$5;
                this.F$6 = F$5;
                super(algorithms$3, F$5);
            }

            public Object verified(Jwt jwt) {
                return this.F$6.pure(this.verifyAsymmetric(jwt, this.key$6) ? Some$.MODULE$.apply((Object)BoxedUnit.UNIT) : None$.MODULE$);
            }
        };
    }

    public <F> JwtVerifier<F, JwtAsymmetricAlgorithm, BoxedUnit> asymmetric(PublicKey key, MonadError<F, Throwable> F) {
        return this.asymmetric(key, JwtAlgorithm$.MODULE$.allAsymmetric(), F);
    }

    public <F> JwtVerifier<F, JwtRSAAlgorithm, BoxedUnit> rsa(PublicKey key, Seq<JwtRSAAlgorithm> algorithms, MonadError<F, Throwable> F) {
        return this.asymmetric(key, algorithms, F);
    }

    public <F> Seq<JwtRSAAlgorithm> rsa$default$2() {
        return JwtAlgorithm$.MODULE$.allRSA();
    }

    public <F> JwtVerifier<F, JwtECDSAAlgorithm, BoxedUnit> ecdsa(PublicKey key, Seq<JwtECDSAAlgorithm> algorithms, MonadError<F, Throwable> F) {
        return this.asymmetric(key, algorithms, F);
    }

    public <F> Seq<JwtECDSAAlgorithm> ecdsa$default$2() {
        return JwtAlgorithm$.MODULE$.allECDSA();
    }
}

